/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.utils.tree;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.beanizer.utils.serializer.Serializer;

public class ResourceManager {
    private static Hashtable popups = new Hashtable();
    private static Hashtable actions = new Hashtable();
    private static Hashtable icons = new Hashtable();
    private static Hashtable objects = new Hashtable();
    private static int intCounter = 0;
    static /* synthetic */ Class class$org$beanizer$utils$tree$ResourceManager;

    public static void loadResources(InputStream resourceFile) {
        String key;
        Hashtable resHash = (Hashtable)Serializer.deserializeObject(resourceFile);
        Hashtable hash = (Hashtable)resHash.get("icons");
        Enumeration i = hash.keys();
        while (i.hasMoreElements()) {
            key = (String)i.nextElement();
            ResourceManager.addImageIcon(key, (class$org$beanizer$utils$tree$ResourceManager == null ? ResourceManager.class$("org.beanizer.utils.tree.ResourceManager") : class$org$beanizer$utils$tree$ResourceManager).getResource((String)hash.get(key)));
        }
        hash = (Hashtable)resHash.get("actions");
        i = hash.keys();
        while (i.hasMoreElements()) {
            try {
                key = (String)i.nextElement();
                Hashtable actionHash = (Hashtable)hash.get(key);
                Class<?> actionClass = Class.forName(actionHash.get("classpath") + "." + actionHash.get("classname"));
                Action aclass = (Action)actionClass.newInstance();
                aclass.putValue("Name", actionHash.get("text"));
                aclass.putValue("LongDescription", actionHash.get("text"));
                aclass.putValue("SmallIcon", ResourceManager.getImageIcon((String)actionHash.get("icon")));
                ResourceManager.addAction(aclass, key);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        hash = (Hashtable)resHash.get("popups");
        i = hash.keys();
        while (i.hasMoreElements()) {
            JPopupMenu pop = new JPopupMenu();
            String key2 = (String)i.nextElement();
            Hashtable hash2 = (Hashtable)hash.get(key2);
            Enumeration i2 = hash2.keys();
            while (i2.hasMoreElements()) {
                String actionString = (String)hash2.get((String)i2.nextElement());
                pop.add(new JMenuItem(ResourceManager.getAction(actionString)));
            }
            ResourceManager.addPopup(pop, key2);
        }
    }

    public static void addPopup(JPopupMenu popup, String label) {
        if (!popups.containsKey(label)) {
            popups.put(label, popup);
        }
    }

    public static void addAction(Action action, String label) {
        if (!actions.containsKey(label)) {
            actions.put(label, action);
        }
    }

    public static void addImageIcon(String label, URL path) {
        if (!icons.containsKey(label)) {
            icons.put(label, ResourceManager.createImageIcon(path));
        }
    }

    public static void registerObject(Object obj, String label) {
        if (!objects.containsKey(label)) {
            objects.put(label, obj);
        }
    }

    public static void unregisterObject(String label) {
        if (objects.containsKey(label)) {
            objects.remove(label);
        }
    }

    public static Object getObject(String label) {
        if (objects.containsKey(label)) {
            return objects.get(label);
        }
        return null;
    }

    public static JPopupMenu getPopup(String label) {
        return popups.containsKey(label) ? (JPopupMenu)popups.get(label) : null;
    }

    public static Action getAction(String label) {
        return actions.containsKey(label) ? (Action)actions.get(label) : null;
    }

    public static ImageIcon getImageIcon(String label) {
        return icons.containsKey(label) ? (ImageIcon)icons.get(label) : null;
    }

    public static int getNextInt() {
        return intCounter++;
    }

    private static ImageIcon createImageIcon(URL imgURL) {
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: ");
        return null;
    }
}

