/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.tunnel4j.nodes;

import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.beanizer.tunnel4j.SessionManager;
import org.beanizer.utils.tree.BTreeNode;
import org.beanizer.utils.tree.ResourceManager;

public class ConnectionTreeNode
extends DefaultMutableTreeNode
implements BTreeNode {
    String username = "";
    String host = "";
    private boolean expanded = false;
    int sessionNumber;
    JPopupMenu popup = null;
    ImageIcon connectedIcon = null;
    ImageIcon disconnectedIcon = null;

    public ConnectionTreeNode(String username, String host) {
        this.username = username;
        this.host = host;
        this.popup = ResourceManager.getPopup("connection");
        this.connectedIcon = ResourceManager.getImageIcon("blueled");
        this.disconnectedIcon = ResourceManager.getImageIcon("redled");
    }

    public String toString() {
        String disconnected = SessionManager.isConnected(this.username + "@" + this.host + "@" + this.sessionNumber) ? "" : " (disconnected)";
        return this.username + "@" + this.host + disconnected;
    }

    public String getSessionName() {
        return this.username + "@" + this.host + "@" + this.sessionNumber;
    }

    public String getUser() {
        return this.username;
    }

    public String getHost() {
        return this.host;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public void setSessionNumber(int sessionNumber) {
        this.sessionNumber = sessionNumber;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public ImageIcon getPresentIcon() {
        if (SessionManager.isConnected(this.username + "@" + this.host + "@" + this.sessionNumber)) {
            return this.connectedIcon;
        }
        return this.disconnectedIcon;
    }

    public JPopupMenu getPopUpMenu() {
        return this.popup;
    }
}

