/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.tunnel4j.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.beanizer.tunnel4j.SessionManager;
import org.beanizer.tunnel4j.Tunnel4J;
import org.beanizer.tunnel4j.nodes.ConnectionTreeNode;
import org.beanizer.tunnel4j.nodes.PortTreeNode;
import org.beanizer.tunnel4j.nodes.RPortTreeNode;
import org.beanizer.utils.tree.ResourceManager;

public class StartConnAction
extends AbstractAction {
    JTree jtree = null;

    public StartConnAction() {
    }

    public StartConnAction(String text, ImageIcon icon, String desc, Integer mnemonic) {
        super(text, icon);
        this.putValue("ShortDescription", desc);
        this.putValue("MnemonicKey", mnemonic);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            Object selNode;
            if (this.jtree == null) {
                this.jtree = (JTree)ResourceManager.getObject("tunnel4jTree");
            }
            if ((selNode = this.jtree.getLastSelectedPathComponent()) instanceof ConnectionTreeNode) {
                ConnectionTreeNode connNode = (ConnectionTreeNode)selNode;
                SessionManager.startSession(connNode.getUser(), connNode.getHost(), connNode.getSessionNumber());
                Tunnel4J.getInstance().refreshTree();
                for (int t = 0; t < connNode.getChildCount(); ++t) {
                    DefaultMutableTreeNode portNode;
                    if (connNode.getChildAt(t) instanceof PortTreeNode) {
                        portNode = (PortTreeNode)connNode.getChildAt(t);
                        SessionManager.addPortForwardingL(connNode.getSessionName(), new Integer(((PortTreeNode)portNode).getLPort()), ((PortTreeNode)portNode).getRHost(), new Integer(((PortTreeNode)portNode).getRPort()));
                        continue;
                    }
                    if (!(connNode.getChildAt(t) instanceof RPortTreeNode)) continue;
                    portNode = (RPortTreeNode)connNode.getChildAt(t);
                    SessionManager.addPortForwardingR(connNode.getSessionName(), new Integer(((RPortTreeNode)portNode).getRPort()), ((RPortTreeNode)portNode).getRHost(), new Integer(((RPortTreeNode)portNode).getLPort()));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

