/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.tunnel4j;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.beanizer.tunnel4j.About;
import org.beanizer.tunnel4j.ConnectionMonitor;
import org.beanizer.tunnel4j.SessionManager;
import org.beanizer.tunnel4j.nodes.ConnectionTreeNode;
import org.beanizer.tunnel4j.nodes.PortTreeNode;
import org.beanizer.tunnel4j.nodes.RPortTreeNode;
import org.beanizer.tunnel4j.nodes.RootTreeNode;
import org.beanizer.utils.serializer.Serializer;
import org.beanizer.utils.tree.BTreeCellRenderer;
import org.beanizer.utils.tree.BTreeNode;
import org.beanizer.utils.tree.ResourceManager;

public class Tunnel4J
extends JFrame {
    About about = new About();
    private DefaultTreeModel treeModel;
    RootTreeNode rootNode = null;
    Vector expandedNodes = new Vector();
    private static Tunnel4J instance;
    public String mydir = System.getProperty("user.home") + System.getProperty("file.separator") + ".tunnel4j";
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JToolBar jToolBar1;
    private JTree jTree1;
    private JButton loadButton;
    private JButton resetButton;
    private JButton saveButton;
    private JFileChooser fc;

    private Tunnel4J() {
    }

    public void go() {
        this.initComponents();
        this.initLayout();
        this.initDir();
        this.setVisible(true);
        ConnectionMonitor cm = new ConnectionMonitor();
        cm.start();
    }

    public static Tunnel4J getInstance() {
        if (instance == null) {
            instance = new Tunnel4J();
        }
        return instance;
    }

    private void initDir() {
        try {
            File f = new File(this.mydir);
            if (!f.exists() || !f.isDirectory()) {
                f.mkdir();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.fc = new JFileChooser(this.mydir);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jToolBar1 = new JToolBar();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        this.resetButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Tunnel4J 1.5");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Tunnel4J.this.exitForm(evt);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.jTree1.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent evt) {
                Tunnel4J.this.jTree1TreeCollapsed(evt);
            }

            public void treeExpanded(TreeExpansionEvent evt) {
                Tunnel4J.this.jTree1TreeExpanded(evt);
            }
        });
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Tunnel4J.this.jTree1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jToolBar1.setMargin(new Insets(2, 2, 2, 2));
        this.loadButton.setFont(new Font("Dialog", 0, 12));
        this.loadButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/tunnel4j/img/load.png")));
        this.loadButton.setToolTipText("Load configuration");
        this.loadButton.setBorder(null);
        this.loadButton.setFocusPainted(false);
        this.loadButton.setMaximumSize(new Dimension(40, 25));
        this.loadButton.setMinimumSize(new Dimension(30, 25));
        this.loadButton.setPreferredSize(new Dimension(30, 25));
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tunnel4J.this.loadButtonActionPerformed(evt);
            }
        });
        this.loadButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Tunnel4J.this.loadButtonMouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.loadButton);
        this.saveButton.setFont(new Font("Dialog", 0, 12));
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/tunnel4j/img/save.png")));
        this.saveButton.setToolTipText("Save configuration");
        this.saveButton.setBorder(null);
        this.saveButton.setFocusPainted(false);
        this.saveButton.setMaximumSize(new Dimension(40, 25));
        this.saveButton.setMinimumSize(new Dimension(30, 25));
        this.saveButton.setPreferredSize(new Dimension(30, 25));
        this.saveButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Tunnel4J.this.saveButtonMouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.saveButton);
        this.resetButton.setFont(new Font("Dialog", 0, 12));
        this.resetButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/tunnel4j/img/reset.png")));
        this.resetButton.setToolTipText("Disconnect all");
        this.resetButton.setBorder(null);
        this.resetButton.setFocusPainted(false);
        this.resetButton.setMaximumSize(new Dimension(40, 25));
        this.resetButton.setMinimumSize(new Dimension(30, 25));
        this.resetButton.setPreferredSize(new Dimension(40, 25));
        this.resetButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Tunnel4J.this.resetButtonMouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.resetButton);
        this.jSeparator1.setForeground(new Color(255, 255, 255));
        this.jToolBar1.add(this.jSeparator1);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/tunnel4j/img/about.png")));
        this.jButton1.setBorder(null);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Tunnel4J.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                Tunnel4J.this.jButton1MouseClicked(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.pack();
    }

    private void jTree1TreeCollapsed(TreeExpansionEvent evt) {
        this.expandedNodes.remove(evt.getPath());
    }

    private void jTree1TreeExpanded(TreeExpansionEvent evt) {
        this.expandedNodes.add(evt.getPath());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
    }

    private void jButton1MouseClicked(MouseEvent evt) {
        this.about.setSize(300, 200);
        this.about.setVisible(true);
    }

    private void resetButtonMouseClicked(MouseEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "This will stop any active connection.\n Continue?", "Reset connections", 0) == 0) {
            SessionManager.stopAll();
        }
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
    }

    private void saveButtonMouseClicked(MouseEvent evt) {
        int retval = this.fc.showSaveDialog(null);
        if (retval == 0 && JOptionPane.showConfirmDialog(null, "This will overwrite your current configuration file.\n Continue?", "Save", 0) == 0) {
            try {
                Serializer.serializeObject(this.fc.getSelectedFile().getAbsolutePath(), (Object)this.getTree());
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "There's been a problem while trying to save the configuration.", "ERROR", 0);
            }
        }
    }

    private void loadButtonMouseClicked(MouseEvent evt) {
        int retval = this.fc.showOpenDialog(null);
        if (retval == 0 && JOptionPane.showConfirmDialog(null, "Any modification will be lost.\n Continue?", "Load", 0) == 0) {
            try {
                Hashtable result = (Hashtable)Serializer.deserializeObject(this.fc.getSelectedFile().getAbsolutePath());
                this.populateTree(result);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "There's been a problem while trying to load the configuration.", "ERROR", 0);
            }
        }
    }

    private void jTree1MouseClicked(MouseEvent evt) {
        Object selNode = this.jTree1.getLastSelectedPathComponent();
        try {
            if (evt.getButton() == 3) {
                ((BTreeNode)selNode).getPopUpMenu().show(evt.getComponent(), evt.getX(), evt.getY());
            } else if (selNode instanceof ConnectionTreeNode) {
                ConnectionTreeNode node = (ConnectionTreeNode)selNode;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
    }

    private void exitForm(WindowEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "Exit from Tunnel4J?", "Exit", 0) == 0) {
            System.exit(0);
        }
    }

    public void initLayout() {
        Object pop = null;
        ResourceManager.registerObject(this.jTree1, "tunnel4jTree");
        ResourceManager.loadResources(this.getClass().getResourceAsStream("/conf/resource.xml"));
        this.rootNode = new RootTreeNode("Connections");
        this.setSize(350, 400);
        this.jTree1.setCellRenderer(new BTreeCellRenderer());
        this.getInstance().treeModel = new DefaultTreeModel(this.rootNode);
        this.jTree1.setModel(this.getInstance().treeModel);
    }

    private Hashtable getTree() {
        boolean nodeCounter = false;
        Hashtable hash = new Hashtable();
        Enumeration<TreeNode> e = this.rootNode.children();
        while (e.hasMoreElements()) {
            ConnectionTreeNode tNode = (ConnectionTreeNode)e.nextElement();
            Vector<String> sons = new Vector<String>();
            Enumeration<TreeNode> e1 = tNode.children();
            while (e1.hasMoreElements()) {
                DefaultMutableTreeNode pNode;
                TreeNode obj = e1.nextElement();
                if (obj instanceof PortTreeNode) {
                    pNode = (PortTreeNode)obj;
                    sons.add("L:" + ((PortTreeNode)pNode).getLPort() + ":" + ((PortTreeNode)pNode).getRHost() + ":" + ((PortTreeNode)pNode).getRPort());
                    continue;
                }
                pNode = (RPortTreeNode)obj;
                sons.add("R:" + ((RPortTreeNode)pNode).getRPort() + ":" + ((RPortTreeNode)pNode).getRHost() + ":" + ((RPortTreeNode)pNode).getLPort());
            }
            hash.put(tNode.getUser() + "@" + tNode.getHost() + "@" + tNode.getSessionNumber(), sons);
        }
        return hash;
    }

    private void populateTree(Hashtable hash) {
        this.rootNode = new RootTreeNode("Connections");
        Enumeration e = hash.keys();
        while (e.hasMoreElements()) {
            String connData = (String)e.nextElement();
            String[] splitted = connData.split("@");
            ConnectionTreeNode tNode = new ConnectionTreeNode(splitted[0], splitted[1]);
            tNode.setSessionNumber(Integer.parseInt(splitted[2]));
            Vector sons = (Vector)hash.get(connData);
            Enumeration e1 = sons.elements();
            while (e1.hasMoreElements()) {
                DefaultMutableTreeNode pNode;
                String portData = (String)e1.nextElement();
                splitted = portData.split(":");
                if (splitted.length == 3) {
                    splitted = new String[]{"L", splitted[0], splitted[1], splitted[2]};
                    continue;
                }
                if (splitted[0].equals("L")) {
                    pNode = new PortTreeNode(splitted[1], splitted[2], splitted[3]);
                    tNode.add(pNode);
                    continue;
                }
                pNode = new RPortTreeNode(splitted[1], splitted[2], splitted[3]);
                tNode.add(pNode);
            }
            this.rootNode.add(tNode);
        }
        this.getInstance().treeModel = new DefaultTreeModel(this.rootNode);
        this.jTree1.setModel(this.getInstance().treeModel);
        this.expandedNodes.clear();
    }

    public void refreshTree() {
        this.getInstance().treeModel.reload();
        for (int li = 0; li < this.expandedNodes.size(); ++li) {
            try {
                this.jTree1.expandPath((TreePath)this.expandedNodes.get(li));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Tunnel4J t4j = new Tunnel4J();
        t4j.go();
    }
}

