/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.tunnel4j;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.beanizer.tunnel4j.MyUserInfo;
import org.beanizer.tunnel4j.T4JLogger;

public class SessionManager {
    private static Hashtable sessions = new Hashtable();
    private static JSch jsch;
    private static FileOutputStream fout;

    public static boolean startSession(String username, String host, int sessionNumber) {
        try {
            if (!sessions.containsKey(username + "@" + host + "@" + sessionNumber)) {
                Session session = jsch.getSession(username, host, 22);
                session.setOutputStream((OutputStream)fout);
                MyUserInfo ui = new MyUserInfo();
                session.setUserInfo((UserInfo)ui);
                session.connect();
                sessions.put(username + "@" + host + "@" + sessionNumber, session);
            }
        }
        catch (Exception ex) {
            System.out.println("Error while trying to start session.");
            return false;
        }
        return true;
    }

    public static boolean stopSession(String sessionName) {
        try {
            Session session = (Session)sessions.get(sessionName);
            if (session.isConnected()) {
                session.disconnect();
            }
            sessions.remove(sessionName);
            session = null;
        }
        catch (Exception ex) {
            System.out.println("Session does'n exist or is already disconnected. Ignoring...");
            return false;
        }
        return true;
    }

    public static boolean isConnected(String sessionName) {
        Session session = (Session)sessions.get(sessionName);
        return session != null && session.isConnected();
    }

    public static boolean addPortForwardingL(String sessionName, int lPort, String rHost, int rPort) {
        Session session = (Session)sessions.get(sessionName);
        try {
            session.setPortForwardingL(lPort, rHost, rPort);
        }
        catch (Exception ex) {
            System.out.println("Hmmm, didn't get to add forwarding.....");
            return false;
        }
        return true;
    }

    public static boolean addPortForwardingR(String sessionName, int rPort, String rHost, int lPort) {
        Session session = (Session)sessions.get(sessionName);
        try {
            session.setPortForwardingR(rPort, rHost, lPort);
        }
        catch (Exception ex) {
            System.out.println("Hmmm, didn't get to add forwarding.....");
            return false;
        }
        return true;
    }

    public static boolean delPortForwardingL(String sessionName, int lPort) {
        Session session = (Session)sessions.get(sessionName);
        try {
            session.delPortForwardingL(lPort);
        }
        catch (Exception ex) {
            System.out.println("Maybe forwarding already deleted or connection closed");
            return false;
        }
        return true;
    }

    public static boolean delPortForwardingR(String sessionName, int rPort) {
        Session session = (Session)sessions.get(sessionName);
        try {
            session.delPortForwardingR(rPort);
        }
        catch (Exception ex) {
            System.out.println("Maybe forwarding already deleted or connection closed");
            return false;
        }
        return true;
    }

    public static Session getSession(String sessionName) {
        Session session = (Session)sessions.get(sessionName);
        return session;
    }

    public static Enumeration getSessions() {
        return sessions.keys();
    }

    public static void stopAll() {
        Enumeration e = sessions.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Session session = (Session)sessions.get(key);
            session.disconnect();
            session = null;
            sessions.remove(key);
        }
    }

    static {
        T4JLogger t4jlogger = new T4JLogger();
        try {
            t4jlogger.setPrintStream(new PrintStream(new FileOutputStream(System.getProperty("user.home") + System.getProperty("file.separator") + ".tunnel4j" + System.getProperty("file.separator") + "tunnel4j.log")));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            t4jlogger.setPrintStream(System.err);
        }
        JSch.setLogger((Logger)t4jlogger);
        jsch = new JSch();
    }
}

