/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.fesi;

import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.fesi.FesiRpcUtil;

public class FesiRpcServer
extends ObjectPrototype {
    public WebServer srv;
    Evaluator evaluator;

    public FesiRpcServer(WebServer srv, ESObject op, Evaluator eval) throws IOException, EcmaScriptException {
        super(op, eval);
        this.evaluator = eval;
        this.srv = srv;
    }

    public FesiRpcServer(int port, ESObject op, Evaluator eval) throws IOException, EcmaScriptException {
        super(op, eval);
        this.evaluator = eval;
        this.srv = new WebServer(port);
    }

    public void putProperty(String propertyName, ESValue propertyValue, int hash) throws EcmaScriptException {
        if (propertyValue instanceof ESObject) {
            this.srv.addHandler(propertyName, new FesiInvoker((ESObject)propertyValue));
        }
        super.putProperty(propertyName, propertyValue, hash);
    }

    public boolean deleteProperty(String propertyName, int hash) throws EcmaScriptException {
        this.srv.removeHandler(propertyName);
        super.deleteProperty(propertyName, hash);
        return true;
    }

    class FesiInvoker
    implements XmlRpcHandler {
        ESObject target;

        public FesiInvoker(ESObject target) {
            this.target = target;
        }

        public Object execute(String method, Vector argvec) throws Exception {
            int l = argvec.size();
            ESObject callTarget = this.target;
            if (method.indexOf(".") > -1) {
                StringTokenizer st = new StringTokenizer(method, ".");
                int cnt = st.countTokens();
                int i = 1;
                while (i < cnt) {
                    String next = st.nextToken();
                    try {
                        callTarget = (ESObject)callTarget.getProperty(next, next.hashCode());
                    }
                    catch (Exception x) {
                        throw new EcmaScriptException("The property \"" + next + "\" is not defined in the remote object.");
                    }
                    ++i;
                }
                method = st.nextToken();
            }
            ESValue[] args = new ESValue[l];
            int i = 0;
            while (i < l) {
                args[i] = FesiRpcUtil.convertJ2E(argvec.elementAt(i), FesiRpcServer.this.evaluator);
                ++i;
            }
            Object retval = FesiRpcUtil.convertE2J(callTarget.doIndirectCall(FesiRpcServer.this.evaluator, callTarget, method, args));
            return retval;
        }
    }
}

