/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class StandardLoader
extends ClassLoader {
    protected Object[] _classPath;

    public StandardLoader(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("path.separator"));
        this._classPath = new Object[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this._classPath[n++] = this.initPath(stringTokenizer.nextToken());
        }
    }

    protected Object initPath(String string) {
        if (string.substring(string.length() - ".zip".length()).equalsIgnoreCase(".zip")) {
            return this.initZipFile(string);
        }
        return this.initDirectory(string);
    }

    protected File initDirectory(String string) {
        try {
            File file = new File(string);
            if (!file.isDirectory()) {
                throw new IOException();
            }
            return file;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ZipFile initZipFile(String string) {
        try {
            ZipFile zipFile = new ZipFile(string);
            return zipFile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.findSystemClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(string);
        }
        if (clazz == null) {
            byte[] byArray = null;
            for (int i = 0; i < this._classPath.length; ++i) {
                if (this._classPath[i] == null) continue;
                try {
                    byArray = this.loadClassDef(this._classPath[i], string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray != null) break;
            }
            if (byArray != null) {
                clazz = this.defineClass(byArray, 0, byArray.length);
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        throw new ClassNotFoundException("Cannot load class: " + string);
    }

    public byte[] loadClassDef(Object object, String string) throws IOException {
        byte[] byArray = null;
        string = string.replace('.', File.separatorChar) + ".class";
        if (object instanceof File && ((File)object).isDirectory()) {
            File file = (File)object;
            File file2 = new File(file, string);
            byArray = new byte[(int)file2.length()];
            new FileInputStream(file2).read(byArray);
            return byArray;
        }
        if (object instanceof ZipFile) {
            ZipFile zipFile = (ZipFile)object;
            ZipEntry zipEntry = zipFile.getEntry(string);
            if (zipEntry == null) {
                throw new IOException("Entry doesn't exist");
            }
            byArray = new byte[(int)zipEntry.getSize()];
            zipFile.getInputStream(zipEntry).read(byArray);
            return byArray;
        }
        return null;
    }
}

