/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.tools.processmanager;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.javagroup.process.ProcessManagerHolder;
import org.javagroup.tools.processmanager.ProcessDataModel;

public class ProcessWatcherPanel
extends JPanel
implements ActionListener {
    protected JTable _processTable;
    protected JButton _killButton;
    protected ProcessDataModel _dataModel;
    private static final int __MINIMUM_HEIGHT = 200;
    public static final int CLICK_DURATION = 1000;

    public ProcessWatcherPanel() {
        JTable jTable;
        ProcessDataModel processDataModel;
        this._dataModel = processDataModel = new ProcessDataModel();
        this._processTable = jTable = new JTable(processDataModel);
        jTable.setRowSelectionAllowed(true);
        jTable.setColumnSelectionAllowed(false);
        jTable.setCellSelectionEnabled(false);
        jTable.setSelectionMode(0);
        JCheckBox jCheckBox = new JCheckBox();
        Insets insets = jCheckBox.getInsets();
        TableColumn tableColumn = jTable.getColumn(jTable.getModel().getColumnName(0));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer());
        tableColumn.setCellEditor(new DefaultCellEditor(jCheckBox));
        JScrollPane jScrollPane = JTable.createScrollPaneForTable(jTable);
        this._killButton = new JButton("Kill process");
        this._killButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", jScrollPane);
        this.add("South", this._killButton);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return new Dimension(dimension.width, Math.max(200, dimension.height));
    }

    protected void killCurrentSelection() {
        if (this._processTable.getSelectedRow() >= this._processTable.getRowCount()) {
            return;
        }
        try {
            long l = Long.parseLong((String)this._dataModel.getValueAt(this._processTable.getSelectedRow(), 0));
            ProcessManagerHolder.getProcessManager().kill(l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.killCurrentSelection();
    }
}

