/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.tools.processmanager;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessEventListener;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessManagerHolder;
import org.javagroup.tools.processmanager.ProcessTableEntry;

public class ProcessDataModel
extends AbstractTableModel
implements ProcessEventListener {
    protected Vector _processTableEntries = new Vector();
    private static String __NAME = "Process name (including argument list)";
    public static final int C_PID = 0;
    public static final int C_NAME = 1;
    public int numColumns = 2;

    public ProcessDataModel() {
        ProcessManager processManager = ProcessManagerHolder.getProcessManager();
        Enumeration enumeration = processManager.getProcesses();
        while (enumeration.hasMoreElements()) {
            this.createProcessTableEntry((JProcess)enumeration.nextElement());
        }
        processManager.addProcessEventListener(this);
    }

    protected void createProcessTableEntry(JProcess jProcess) {
        ProcessTableEntry processTableEntry = new ProcessTableEntry(jProcess);
        this._processTableEntries.addElement(processTableEntry);
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this._processTableEntries.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n >= this.getRowCount()) {
            return "";
        }
        ProcessTableEntry processTableEntry = (ProcessTableEntry)this._processTableEntries.elementAt(n);
        if (n2 == 0) {
            return String.valueOf(processTableEntry._pid);
        }
        if (n2 == 1) {
            return processTableEntry._name;
        }
        return "NO DATA";
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n > this.getRowCount()) {
            return;
        }
        ProcessTableEntry processTableEntry = (ProcessTableEntry)this._processTableEntries.elementAt(n);
        ProcessManagerHolder.getProcessManager().kill(processTableEntry._pid);
        this.fireTableDataChanged();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "PID";
            }
            case 1: {
                return __NAME;
            }
        }
        return "Undefined";
    }

    public Class getColumnClass(int n) {
        return this.getValueAt(0, n).getClass();
    }

    public void processCreated(JProcess jProcess) {
        this.createProcessTableEntry(jProcess);
        this.fireTableDataChanged();
    }

    public void processDestroyed(JProcess jProcess) {
        this._processTableEntries.removeElement(new ProcessTableEntry(jProcess));
        this.fireTableDataChanged();
    }
}

