/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.tools.processmanager;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.process.ProcessManagerHolder;
import org.javagroup.swing.HistoryComboModel;

public class LaunchProcessPanel
extends JPanel
implements ActionListener {
    protected HistoryComboModel _comboModel;
    protected JComboBox _classNameField;
    protected JButton _launchButton;

    public LaunchProcessPanel() {
        this.instantiateComponents();
        this.addAndLayoutComponents();
        this.registerListeners();
    }

    protected void instantiateComponents() {
        this._comboModel = new HistoryComboModel();
        this._classNameField = new JComboBox();
        this._classNameField.setEditable(true);
        this._launchButton = new JButton("Launch");
    }

    protected void addAndLayoutComponents() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(this._classNameField, gridBagConstraints);
        this.add(this._classNameField);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this._launchButton, gridBagConstraints);
        this.add(this._launchButton);
    }

    protected void registerListeners() {
        this._launchButton.addActionListener(this);
    }

    protected void showErrorDialog(Exception exception) {
        System.out.println(exception);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this._classNameField.getSelectedItem();
        try {
            this._comboModel.addToHistory(string);
            ProcessManagerHolder.getProcessManager().createProcessFromString(string).launch();
        }
        catch (ProcessCreationException processCreationException) {
            this.showErrorDialog(processCreationException);
        }
    }
}

