/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.process;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.process.ProcessEventListener;
import org.javagroup.process.ProcessGarbageCollector;
import org.javagroup.process.ProcessLifeToken;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessNamespace;
import org.javagroup.process.ProcessSecurityManager;
import org.javagroup.process.StandardJProcess;
import org.javagroup.util.Namespace;
import org.javagroup.util.Resource;
import org.javagroup.util.ResourceDisposalListener;
import org.javagroup.util.StandardIO;
import org.javagroup.util.URLClassLoader;

public class StandardProcessManager
implements ProcessManager,
ResourceDisposalListener {
    protected URL[] _classpath;
    protected Hashtable _processes;
    protected ProcessSecurityManager _securityManager;
    protected Vector _processEventListeners;
    protected ProcessGarbageCollector _garbageCollector;
    protected ProcessNamespace _namespace;
    protected Vector _garbageQueue;
    protected ThreadGroup _rootProcessGroup = new ThreadGroup("ThreadGroup for JProcesses");
    private long _nextpid;
    static /* synthetic */ Class class$org$javagroup$util$StandardIO;

    public StandardProcessManager() {
        this._processes = new Hashtable();
        this._processEventListeners = new Vector();
        this._garbageQueue = new Vector();
        this._garbageCollector = new ProcessGarbageCollector(this);
        this._namespace = new ProcessNamespace(this);
        Namespace.getNamespace().registerNamespace(this._namespace);
        this._securityManager = new ProcessSecurityManager(this);
        System.setSecurityManager(this._securityManager);
    }

    public StandardProcessManager(URL[] uRLArray) {
        this();
        this._classpath = uRLArray;
    }

    protected synchronized long getNextPid() {
        return this._nextpid++;
    }

    public JProcess createProcess(String string) throws ProcessCreationException {
        return this.createProcess(string, new String[0], null);
    }

    public JProcess createProcess(String string, String[] stringArray) throws ProcessCreationException {
        return this.createProcess(string, stringArray, null);
    }

    public synchronized JProcess createProcess(String string, String[] stringArray, URL[] uRLArray) throws ProcessCreationException {
        StandardIO.ensureSystemWrappersInstalled();
        uRLArray = uRLArray == null ? this._classpath : this.mergeWithDefaultClasspath(uRLArray);
        StandardJProcess standardJProcess = new StandardJProcess(string, this.getNextPid(), stringArray, this._rootProcessGroup, uRLArray);
        ProcessLifeToken processLifeToken = new ProcessLifeToken(standardJProcess);
        processLifeToken.addDisposalListener(this);
        standardJProcess.registerResource(processLifeToken);
        this._processes.put(new Long(standardJProcess.getPid()), standardJProcess);
        this.fireProcessCreationEvent(standardJProcess);
        this._namespace.registerNamespaceForProcess(new Namespace(), standardJProcess);
        return standardJProcess;
    }

    public JProcess createProcessFromString(String string) throws ProcessCreationException {
        return this.createProcessFromString(string, null);
    }

    public JProcess createProcessFromString(String string, URL[] objectArray) throws ProcessCreationException {
        int n;
        Object[] objectArray2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() < 1) {
            throw new ProcessCreationException("Invalid parameter string.");
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.equals("-eclasspath")) {
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ProcessCreationException("Must specify a classpath with -eclasspath option");
            }
            objectArray2 = URLClassLoader.decodePathString(stringTokenizer.nextToken());
            if (objectArray == null || objectArray.length == 0) {
                objectArray = objectArray2;
            } else if (objectArray2 != null || objectArray2.length != 0) {
                n = objectArray.length + objectArray2.length;
                URL[] uRLArray = new URL[n];
                System.arraycopy(objectArray2, 0, uRLArray, 0, objectArray2.length);
                System.arraycopy(objectArray, 0, uRLArray, objectArray2.length, uRLArray.length);
                objectArray = uRLArray;
            }
            if (!stringTokenizer.hasMoreTokens()) {
                throw new ProcessCreationException("Must specify a classname");
            }
            string2 = stringTokenizer.nextToken();
        }
        objectArray2 = new String[stringTokenizer.countTokens()];
        for (n = 0; n < objectArray2.length; ++n) {
            objectArray2[n] = stringTokenizer.nextToken();
        }
        return this.createProcess(string2, (String[])objectArray2, (URL[])objectArray);
    }

    public JProcess getProcessFor(ThreadGroup threadGroup) {
        Enumeration enumeration = this._processes.elements();
        JProcess jProcess = null;
        while (jProcess == null && enumeration.hasMoreElements()) {
            JProcess jProcess2 = (JProcess)enumeration.nextElement();
            ThreadGroup threadGroup2 = jProcess2.getThreadGroup();
            if (!threadGroup2.parentOf(threadGroup)) continue;
            jProcess = jProcess2;
        }
        return jProcess;
    }

    public JProcess getProcessFor(ClassLoader classLoader) {
        Enumeration enumeration = this._processes.elements();
        JProcess jProcess = null;
        while (jProcess == null && enumeration.hasMoreElements()) {
            JProcess jProcess2 = (JProcess)enumeration.nextElement();
            ClassLoader classLoader2 = jProcess2.getClassLoader();
            if (classLoader != classLoader2) continue;
            jProcess = jProcess2;
        }
        return jProcess;
    }

    protected URL[] mergeWithDefaultClasspath(URL[] uRLArray) {
        int n;
        if (this._classpath == null) {
            return uRLArray;
        }
        if (uRLArray == null) {
            return this._classpath;
        }
        URL[] uRLArray2 = new URL[uRLArray.length + this._classpath.length];
        for (n = 0; n < uRLArray.length; ++n) {
            uRLArray2[n] = uRLArray[n];
        }
        for (n = 0; n < this._classpath.length; ++n) {
            uRLArray2[n + uRLArray.length] = this._classpath[n];
        }
        return uRLArray2;
    }

    public JProcess getCurrentProcess() {
        return this._securityManager.getCurrentProcess();
    }

    public JProcess getProcess(long l) {
        return (JProcess)this._processes.get(new Long(l));
    }

    public Enumeration getProcesses() {
        return this._processes.elements();
    }

    public synchronized void kill(long l) {
        JProcess jProcess = (JProcess)this._processes.remove(new Long(l));
        if (jProcess != null) {
            this._garbageQueue.addElement(jProcess);
            this._garbageCollector.wakeUp();
        }
    }

    public void addProcessEventListener(ProcessEventListener processEventListener) {
        this._processEventListeners.addElement(processEventListener);
    }

    public void removeProcessEventListener(ProcessEventListener processEventListener) {
        this._processEventListeners.removeElement(processEventListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProcessDestructionEvent(JProcess jProcess) {
        Vector vector = this._processEventListeners;
        synchronized (vector) {
            for (int i = 0; i < this._processEventListeners.size(); ++i) {
                ProcessEventListener processEventListener = (ProcessEventListener)this._processEventListeners.elementAt(i);
                processEventListener.processDestroyed(jProcess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProcessCreationEvent(JProcess jProcess) {
        Vector vector = this._processEventListeners;
        synchronized (vector) {
            for (int i = 0; i < this._processEventListeners.size(); ++i) {
                ProcessEventListener processEventListener = (ProcessEventListener)this._processEventListeners.elementAt(i);
                processEventListener.processCreated(jProcess);
            }
        }
    }

    public void resourceDisposed(Resource resource) {
        if (resource instanceof ProcessLifeToken) {
            JProcess jProcess = ((ProcessLifeToken)resource).getProcess();
            this.kill(jProcess.getPid());
        }
    }

    public synchronized void doGarbageCollect() {
        Object object;
        StandardIO.ensureSystemWrappersInstalled();
        Enumeration enumeration = this._garbageQueue.elements();
        while (enumeration.hasMoreElements()) {
            object = (StandardJProcess)enumeration.nextElement();
            ((StandardJProcess)object).kill();
            this._namespace.removeNamespaceForProcess((JProcess)object);
            this.fireProcessDestructionEvent((JProcess)object);
        }
        this._garbageQueue.removeAllElements();
        object = this._processes.elements();
        while (object.hasMoreElements()) {
            StandardJProcess standardJProcess = (StandardJProcess)object.nextElement();
            standardJProcess.tryGarbageCollect();
        }
        System.gc();
    }

    public Namespace getNamespaceForProcess(JProcess jProcess) {
        return this._namespace.getNamespaceForProcess(jProcess);
    }

    public void setStandardIOForProcess(JProcess jProcess, StandardIO standardIO) {
        Namespace namespace = this.getNamespaceForProcess(jProcess);
        namespace.registerInstanceForClass(class$org$javagroup$util$StandardIO == null ? (class$org$javagroup$util$StandardIO = StandardProcessManager.class$("org.javagroup.util.StandardIO")) : class$org$javagroup$util$StandardIO, standardIO);
    }

    public StandardIO getStandardIOForProcess(JProcess jProcess) {
        Namespace namespace = this.getNamespaceForProcess(jProcess);
        return (StandardIO)namespace.getInstanceForClass(class$org$javagroup$util$StandardIO == null ? (class$org$javagroup$util$StandardIO = StandardProcessManager.class$("org.javagroup.util.StandardIO")) : class$org$javagroup$util$StandardIO);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

