/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.process;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Vector;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.util.Resource;
import org.javagroup.util.ResourceDisposalListener;

public class StandardJProcess
implements Runnable,
JProcess,
ResourceDisposalListener {
    protected long _pid;
    protected String _name;
    protected Date _creationdate;
    protected URLClassLoader _classLoader;
    protected ThreadGroup _processThreadGroup;
    protected Vector _lockedResources;
    protected Vector _resourcesLockedTo;
    protected int _state;
    protected int _exitCode;
    private Method _targetMethod;
    private String[] _args;
    private Thread _mainThread;
    private boolean _isKilled;
    static /* synthetic */ Class array$Ljava$lang$String;

    public StandardJProcess(String string, long l, String[] stringArray, ThreadGroup threadGroup, URL[] uRLArray) throws ProcessCreationException {
        this._name = string;
        this._creationdate = new Date();
        this._args = stringArray;
        this.setState(0);
        this._lockedResources = new Vector();
        this._resourcesLockedTo = new Vector();
        if (this._args == null) {
            this._args = new String[0];
        }
        for (int i = 0; i < this._args.length; ++i) {
            this._name = this._name + " " + this._args[i];
        }
        this._pid = l;
        this._classLoader = null;
        this._classLoader = uRLArray != null ? URLClassLoader.newInstance(uRLArray) : URLClassLoader.newInstance(null);
        this._processThreadGroup = this.createThreadGroup(threadGroup);
        try {
            this.setTargetClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProcessCreationException(classNotFoundException.toString());
        }
        catch (Exception exception) {
            throw new ProcessCreationException(exception.toString());
        }
    }

    public void launch() {
        this._mainThread = new Thread(this._processThreadGroup, this, "Main thread for " + this._name);
        this._mainThread.start();
        this.setState(1);
        Thread.yield();
    }

    public Thread getMainThread() {
        return this._mainThread;
    }

    public void addClassPath(URL[] uRLArray) {
    }

    public void run() {
        try {
            Object[] objectArray = new Object[]{this._args};
            this._targetMethod.invoke(null, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected URLClassLoader createClassLoader() {
        URL[] uRLArray = null;
        return URLClassLoader.newInstance(uRLArray);
    }

    protected ThreadGroup createThreadGroup(ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = new ThreadGroup(threadGroup, this.toString());
        threadGroup2.setMaxPriority(9);
        return threadGroup2;
    }

    private void setTargetClass(String string) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = this._classLoader.loadClass(string);
        Class[] classArray = new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = StandardJProcess.class$("[Ljava.lang.String;")) : array$Ljava$lang$String};
        this._targetMethod = clazz.getMethod("main", classArray);
        if ((this._targetMethod.getModifiers() & 8) == 0 || (this._targetMethod.getModifiers() & 1) == 0) {
            throw new NoSuchMethodException("main(String[]) method of " + clazz.getName() + " is not public and static.");
        }
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ThreadGroup getThreadGroup() {
        return this._processThreadGroup;
    }

    public synchronized void registerResource(Resource resource) {
        if (!this._lockedResources.contains(resource)) {
            this._lockedResources.addElement(resource);
            resource.addLock();
        }
    }

    public synchronized void registerAndBindToResource(Resource resource) {
        this.registerResource(resource);
        this.bindToResource(resource);
    }

    public synchronized void bindToResource(Resource resource) {
        if (!this._resourcesLockedTo.contains(resource)) {
            this._resourcesLockedTo.addElement(resource);
            resource.addDisposalListener(this);
        }
    }

    public synchronized void releaseResources() {
        Object[] objectArray = new Resource[this._lockedResources.size()];
        this._lockedResources.copyInto(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this.releaseResource((Resource)objectArray[i]);
        }
    }

    protected synchronized void releaseResource(Resource resource) {
        if (this._lockedResources.contains(resource)) {
            try {
                resource.releaseLock();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this._lockedResources.removeElement(resource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._resourcesLockedTo.contains(resource)) {
            this._resourcesLockedTo.removeElement(resource);
        }
    }

    public void resourceDisposed(Resource resource) {
        this.releaseResource(resource);
    }

    public synchronized void kill() {
        if (this._isKilled) {
            return;
        }
        this.setState(2);
        this.releaseResources();
        this._isKilled = true;
        this._processThreadGroup.stop();
        this._classLoader = null;
    }

    private synchronized void kill_destroyThreadGroup() {
        if (this._processThreadGroup != null) {
            this._processThreadGroup.destroy();
            this._processThreadGroup = null;
        }
    }

    public synchronized void tryGarbageCollect() {
        if (this._state != 0 && this._state != 2 && this._resourcesLockedTo.isEmpty() && this._processThreadGroup.activeCount() <= 0) {
            this.kill();
            this.kill_destroyThreadGroup();
        }
    }

    public long getPid() {
        return this._pid;
    }

    public String getName() {
        return this._name;
    }

    public Date getCreationDate() {
        return this._creationdate;
    }

    public int getState() {
        return this._state;
    }

    protected synchronized void setState(int n) {
        this._state = n;
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (this.getState() != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(int n) {
        this._exitCode = n;
    }

    public String toString() {
        return String.valueOf(this._pid) + ": " + this._name;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

