/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.process;

import java.util.Hashtable;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessManager;
import org.javagroup.util.Namespace;

public class ProcessNamespace
extends Namespace {
    protected ProcessManager _processManager;
    protected Hashtable _processToNamespaceMap;

    public ProcessNamespace(ProcessManager processManager) {
        this._processManager = processManager;
        this._processToNamespaceMap = new Hashtable();
    }

    public synchronized void registerNamespaceToProcess(Namespace namespace, JProcess jProcess) {
        if (jProcess != null) {
            Namespace namespace2 = this.getNamespaceForProcess(jProcess);
            if (namespace2 != null) {
                namespace2.registerNamespace(namespace);
            }
        } else {
            super.registerNamespace(namespace);
        }
    }

    public synchronized void registerNamespace(Namespace namespace) {
        this.registerNamespaceToProcess(namespace, this._processManager.getCurrentProcess());
    }

    public synchronized void registerNamespaceForProcess(Namespace namespace, JProcess jProcess) {
        this._processToNamespaceMap.put(jProcess, namespace);
    }

    public synchronized Namespace getNamespaceForProcess(JProcess jProcess) {
        if (jProcess == null) {
            return null;
        }
        Namespace namespace = (Namespace)this._processToNamespaceMap.get(jProcess);
        if (namespace == null) {
            namespace = new Namespace();
            this._processToNamespaceMap.put(jProcess, namespace);
        }
        return namespace;
    }

    public synchronized void removeNamespaceForProcess(JProcess jProcess) {
        this._processToNamespaceMap.remove(jProcess);
    }

    public synchronized void registerInstanceForClass(Class clazz, Object object) {
        Namespace namespace = this.getNamespaceForProcess(this._processManager.getCurrentProcess());
        if (namespace != null) {
            namespace.registerInstanceForClass(clazz, object);
        } else {
            super.registerInstanceForClass(clazz, object);
        }
    }

    public synchronized Object getInstanceForClass(Class clazz) {
        Namespace namespace = this.getNamespaceForProcess(this._processManager.getCurrentProcess());
        Object object = null;
        if (namespace != null) {
            object = namespace.getInstanceForClass(clazz);
        }
        if (object == null) {
            object = super.getInstanceForClass(clazz);
        }
        return object;
    }
}

