/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.misc;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.javagroup.disposer.SocketDisposer;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessManagerHolder;
import org.javagroup.util.NullInputStream;
import org.javagroup.util.Resource;
import org.javagroup.util.StandardIO;

public class ProcessService
implements Runnable {
    public static final int DEFAULT_PORT = 7080;
    protected ServerSocket _serverSocket;

    public ProcessService() throws IOException {
        this(7080);
    }

    public ProcessService(int n) throws IOException {
        this._serverSocket = new ServerSocket(n);
        new Thread(this).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                Socket socket = null;
                PrintStream printStream = null;
                try {
                    socket = this._serverSocket.accept();
                    PrintStream printStream2 = printStream = new PrintStream(socket.getOutputStream());
                    PrintStream printStream3 = printStream;
                    NullInputStream nullInputStream = new NullInputStream();
                    StandardIO standardIO = new StandardIO(printStream3, nullInputStream, printStream2);
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    String string = dataInputStream.readLine();
                    ProcessManager processManager = ProcessManagerHolder.getProcessManager();
                    JProcess jProcess = processManager.createProcessFromString(string);
                    processManager.setStandardIOForProcess(jProcess, standardIO);
                    Resource resource = new Resource(new SocketDisposer(socket));
                    jProcess.registerResource(resource);
                    jProcess.launch();
                }
                catch (Exception exception) {
                    try {
                        printStream.println(exception);
                        socket.close();
                    }
                    catch (Exception exception2) {}
                }
            }
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            exceptionInInitializerError.getException().printStackTrace();
            return;
        }
    }

    public void finalize() {
        try {
            this._serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(String[] stringArray) throws Exception {
        new ProcessService();
    }
}

