/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.jdsvm.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import org.beanizer.jdsvm.Jdsvm;
import org.beanizer.jdsvm.JdsvmListener;

public class ManagerSwing
extends JFrame
implements JdsvmListener,
ActionListener {
    private Jdsvm jdsvm = null;
    private URL[] url;
    String[] statusIcon = new String[3];
    private JTable activeProcessTable;
    private JTextField classpathTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton killButton;
    private JButton launchButton;
    private JTextField programTextField;
    private JButton refreshButton;
    private ProcessTableModel processTableModel = null;

    private void pmInitialize() {
        try {
            this.jdsvm = Jdsvm.getInstance();
            this.jdsvm.addJdsvmListener(this);
            this.initComponents();
            this.statusIcon[0] = "unstarted";
            this.statusIcon[1] = "running";
            this.statusIcon[2] = "dead";
            this.listProcess();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.setTitle("JDE Manager");
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.programTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.classpathTextField = new JTextField();
        this.launchButton = new JButton();
        this.jPanel3 = new JPanel();
        this.activeProcessTable = new JTable();
        this.jPanel4 = new JPanel();
        this.killButton = new JButton();
        this.refreshButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ManagerSwing.this.exitForm(windowEvent);
            }
        });
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Program");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.programTextField.setName("programTextField");
        this.programTextField.setPreferredSize(new Dimension(400, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.jPanel1.add((Component)this.programTextField, gridBagConstraints);
        this.jLabel2.setText("Classpath");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 100;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.classpathTextField.setName("classpathTextField");
        this.classpathTextField.setPreferredSize(new Dimension(400, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 100;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.jPanel1.add((Component)this.classpathTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 100.0;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.launchButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/jdsvm/img/launch.gif")));
        this.launchButton.setText("Launch");
        this.launchButton.setName("launchButton");
        this.launchButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ManagerSwing.this.launchButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(5, 5, 15, 5);
        this.jPanel2.add((Component)this.launchButton, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setBorder(new TitledBorder(null, "Active processes", 0, 0, new Font("Dialog", 1, 11)));
        JScrollPane jScrollPane = new JScrollPane(this.activeProcessTable);
        this.activeProcessTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.processTableModel = new ProcessTableModel(new Object[][]{{"", "", ""}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"ID", "Process name", "Status"});
        this.activeProcessTable.setModel(this.processTableModel);
        this.activeProcessTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.activeProcessTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.jPanel3.add((Component)jScrollPane, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.killButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/jdsvm/img/kill.gif")));
        this.killButton.setText("Kill");
        this.killButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ManagerSwing.this.killButtonMouseClicked(mouseEvent);
            }
        });
        this.jPanel4.add(this.killButton);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/jdsvm/img/refresh.gif")));
        this.refreshButton.setText("Refresh");
        this.refreshButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                ManagerSwing.this.refreshButtonMouseClicked(mouseEvent);
            }
        });
        this.jPanel4.add(this.refreshButton);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jMenu1.setText("History");
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        Enumeration enumeration = this.jdsvm.getCommands().keys();
        while (enumeration.hasMoreElements()) {
            this.addMenuItem((String)enumeration.nextElement());
        }
        this.pack();
    }

    private void refreshButtonMouseClicked(MouseEvent mouseEvent) {
        this.listProcess();
        try {
            UIManager.setLookAndFeel("com.birosoft.liquid.LiquidLookAndFeel");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void killButtonMouseClicked(MouseEvent mouseEvent) {
        if (this.activeProcessTable.getSelectedRow() > -1) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ManagerSwing.this.jdsvm.killProcess((String)ManagerSwing.this.processTableModel.getValueAt(ManagerSwing.this.activeProcessTable.getSelectedRow(), 0));
                }
            };
            new Thread(runnable).start();
        }
    }

    private void launchButtonMouseClicked(MouseEvent mouseEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                ManagerSwing.this.launchProcess(ManagerSwing.this.programTextField.getText(), ManagerSwing.this.classpathTextField.getText());
            }
        };
        new Thread(runnable).start();
    }

    private void exitForm(WindowEvent windowEvent) {
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        ManagerSwing managerSwing = new ManagerSwing();
        managerSwing.pmInitialize();
        managerSwing.show();
    }

    public void launchProcess(String string, String string2) {
        this.jdsvm.launchProcess(string, string2);
    }

    private void addMenuItem(String string) {
        final JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(this);
        final String string2 = string;
        Runnable runnable = new Runnable(){

            public void run() {
                jMenuItem.setText(string2);
                ManagerSwing.this.jMenu1.add(jMenuItem);
                ManagerSwing.this.jMenu1.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        final URL[] uRLArray = (URL[])this.jdsvm.getCommands().get(jMenuItem.getText());
        Runnable runnable = new Runnable(){

            public void run() {
                ManagerSwing.this.jdsvm.launchProcessFromXmlRPC(jMenuItem.getText(), uRLArray);
            }
        };
        new Thread(runnable).start();
    }

    private void launchFromMenu(String string) {
    }

    protected void listProcess() {
        Vector vector = this.jdsvm.getProcessList();
        Object[][] objectArray = new Object[vector.size() + 1][3];
        Enumeration enumeration = vector.elements();
        for (int i = 0; i < vector.size(); ++i) {
            HashMap hashMap = (HashMap)enumeration.nextElement();
            objectArray[i][0] = hashMap.get("pid");
            objectArray[i][1] = hashMap.get("name");
            objectArray[i][2] = "running";
        }
        this.processTableModel.setDataVector(objectArray, new String[]{"ID", "Process name", "Status"});
        this.processTableModel.fireTableDataChanged();
    }

    public void processCreated(String string, String string2, int n) {
        this.listProcess();
        if (!this.jdsvm.getCommands().containsKey(string2)) {
            this.addMenuItem(string2);
        }
    }

    public void processDestroyed(String string, String string2) {
        this.listProcess();
    }

    public void jdsvmError(Throwable throwable) {
        throwable.printStackTrace();
    }

    class ProcessTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] data;
        private boolean DEBUG = false;

        public ProcessTableModel(Object[][] objectArray, String[] stringArray) {
            this.columnNames = stringArray;
            this.data = objectArray;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            if (this.DEBUG) {
                System.out.println("Setting value at " + n + "," + n2 + " to " + object + " (an instance of " + object.getClass() + ")");
            }
            this.data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
            if (this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        public void setDataVector(Object[][] objectArray, String[] stringArray) {
            this.columnNames = stringArray;
            this.data = objectArray;
        }

        private void printDebugData() {
            int n = this.getRowCount();
            int n2 = this.getColumnCount();
            for (int i = 0; i < n; ++i) {
                System.out.print("    row " + i + ":");
                for (int j = 0; j < n2; ++j) {
                    System.out.print("  " + this.data[i][j]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

