/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.jdsvm;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.beanizer.jdsvm.JdsvmListener;
import org.beanizer.jdsvm.util.CommandLineParser;
import org.beanizer.jdsvm.util.StringUtils;
import org.beanizer.jdsvm.xmlrpc.engine.XmlRpcServer;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.process.ProcessEventListener;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessManagerHolder;

public class Jdsvm
implements ProcessEventListener {
    static Logger logger = Logger.getLogger((String)"Jdsvm");
    private static Vector listeners = new Vector();
    private URL[] url;
    private ProcessManager manager = ProcessManagerHolder.getProcessManager();
    private static Jdsvm JdsvmSingleton = null;
    private Hashtable commands = new Hashtable();
    private static boolean startManager = false;
    private static Properties properties = new Properties();

    private Jdsvm() {
    }

    private void JdsvmInitialize() {
        try {
            ProcessManagerHolder.getProcessManager().addProcessEventListener(this);
            logger.info((Object)"Jdsvm initialized");
        }
        catch (Exception exception) {
            logger.error((Object)("Jdsvm initialization failed : " + exception.getMessage()));
            exception.printStackTrace();
        }
        try {
            File file = new File("conf/properties.conf");
            file.createNewFile();
            properties.load(new FileInputStream("conf/properties.conf"));
        }
        catch (Exception exception) {
            logger.error((Object)("Jdsvm properties initialization failed : " + exception.getMessage()));
        }
    }

    public static Jdsvm getInstance() {
        if (JdsvmSingleton == null) {
            JdsvmSingleton = new Jdsvm();
            JdsvmSingleton.JdsvmInitialize();
        }
        return JdsvmSingleton;
    }

    public static boolean exists() {
        return JdsvmSingleton != null;
    }

    public static void main(String[] stringArray) {
        PropertyConfigurator.configure((String)"conf/log4j.conf");
        if (!Jdsvm.exists()) {
            logger.info((Object)"*********************");
            logger.info((Object)"* JavaDesktopEngine *");
            logger.info((Object)"*        by         *");
            logger.info((Object)"*   beanizer.org    *");
            logger.info((Object)"*********************");
            CommandLineParser commandLineParser = new CommandLineParser();
            Hashtable hashtable = commandLineParser.parse(stringArray);
            if (hashtable == null) {
                System.out.println(commandLineParser.getLastError());
                System.exit(0);
            }
            if (hashtable.containsKey("help")) {
                System.out.println("HELP!!");
                System.exit(0);
            }
            if (hashtable.containsKey("LnF")) {
                try {
                    UIManager.setLookAndFeel((String)hashtable.get("LnF"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println("ERROR: class " + (String)hashtable.get("LnF") + " not found.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (hashtable.containsKey("GUIManager")) {
                startManager = true;
            }
            XmlRpcServer xmlRpcServer = new XmlRpcServer();
            Jdsvm jdsvm = Jdsvm.getInstance();
            if (startManager) {
                jdsvm.launchProcess("org.beanizer.jdsvm.manager.ManagerSwing", "./");
            }
        } else {
            logger.info((Object)"Jdsvm instance already exists");
        }
    }

    public String launchProcess(String string, String string2) {
        return this.launchProcessFromXmlRPC(string, StringUtils.URLizeClasspath(string2));
    }

    public void killProcess(String string) {
        try {
            this.manager.getProcess(new Long(string)).kill();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.info((Object)"No process to kill selected");
        }
    }

    public Vector getProcessList() {
        Vector vector = new Vector();
        Enumeration enumeration = this.manager.getProcesses();
        while (enumeration.hasMoreElements()) {
            JProcess jProcess = (JProcess)enumeration.nextElement();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("pid", String.valueOf(jProcess.getPid()));
            hashMap.put("name", jProcess.getName());
            hashMap.put("state", String.valueOf(jProcess.getState()));
            hashMap.put("date", jProcess.getCreationDate().toString());
            vector.add(hashMap);
        }
        return vector;
    }

    public String launchProcessFromXmlRPC(String string, URL[] uRLArray) {
        JProcess jProcess = null;
        try {
            jProcess = this.manager.createProcessFromString(string, uRLArray);
            jProcess.launch();
            if (!this.commands.containsKey(string)) {
                this.commands.put(string.trim(), uRLArray);
            }
            return "Process launched";
        }
        catch (ProcessCreationException processCreationException) {
            logger.info((Object)("Error crating process: " + processCreationException.getMessage()));
            this.notifyError(processCreationException);
            return "Error crating process: " + processCreationException.getMessage();
        }
        catch (Exception exception) {
            this.notifyError(exception);
            return "Generic error: " + exception.getMessage();
        }
    }

    protected void updateCommonClasspath() {
    }

    public Hashtable getCommands() {
        return this.commands;
    }

    public void processCreated(JProcess jProcess) {
        logger.info((Object)("Process created : " + jProcess.getName()));
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JdsvmListener)enumeration.nextElement()).processCreated(String.valueOf(jProcess.getPid()), jProcess.getName(), jProcess.getState());
        }
    }

    public void processDestroyed(JProcess jProcess) {
        logger.info((Object)("Process destroyed : " + jProcess.getName()));
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JdsvmListener)enumeration.nextElement()).processDestroyed(String.valueOf(jProcess.getPid()), jProcess.getName());
        }
    }

    private void notifyError(Throwable throwable) {
        Enumeration enumeration = listeners.elements();
        while (enumeration.hasMoreElements()) {
            ((JdsvmListener)enumeration.nextElement()).jdsvmError(throwable);
        }
    }

    public void callBack() {
    }

    public void addJdsvmListener(JdsvmListener jdsvmListener) {
        listeners.add(jdsvmListener);
    }

    public void removeJdsvmListener(JdsvmListener jdsvmListener) {
        if (listeners.contains(jdsvmListener)) {
            listeners.remove(jdsvmListener);
        }
    }

    public String getProperty(String string) {
        return properties.getProperty(string);
    }
}

