/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class URLClassLoader
extends ClassLoader {
    protected Vector _urlClassPath = new Vector();
    protected Hashtable _classCache = new Hashtable();

    public URLClassLoader() {
    }

    public URLClassLoader(URL classpath) {
        this();
        this.addClassPath(classpath);
    }

    public URLClassLoader(URL[] classpath) {
        this();
        this.addClassPath(classpath);
    }

    public void addClassPath(URL[] classpath) {
        for (int i = 0; i < classpath.length; ++i) {
            this.addClassPath(classpath[i]);
        }
    }

    public void addClassPath(URL classpath) {
        this._urlClassPath.addElement(classpath);
    }

    public Class loadMainClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, true, true);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass(name, resolve, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Class loadClass(String name, boolean resolve, boolean mainClass) throws ClassNotFoundException {
        Class<?> klass;
        block10: {
            Class<?> clazz;
            klass = null;
            try {
                klass = this.findSystemClass(name);
                if (klass == null) break block10;
                clazz = klass;
                if (klass == null) return clazz;
                if (!resolve) return clazz;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
                break block10;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            this.resolveClass(klass);
            return clazz;
        }
        klass = (Class<?>)this._classCache.get(name);
        if (klass != null) {
            return klass;
        }
        byte[] data = this.readClassFile(name);
        if (data != null) {
            if (mainClass) {
                this.forcePublic(data);
            }
            klass = this.defineClass(name, data, 0, data.length);
        }
        if (klass == null) {
            throw new ClassNotFoundException("Class not found: " + name);
        }
        this._classCache.put(name, klass);
        return klass;
    }

    protected byte[] readClassFile(String classname) {
        classname = classname.replace('.', '/') + ".class";
        return this.readFile(classname);
    }

    public InputStream getResourceAsStream(String name) {
        byte[] data = this.readFile(name);
        return data == null ? null : new ByteArrayInputStream(data);
    }

    public URL getResource(String name) {
        URL path = null;
        Enumeration classpath = this._urlClassPath.elements();
        while (classpath.hasMoreElements()) {
            URL base_path = (URL)classpath.nextElement();
            try {
                path = new URL(base_path, name);
                return path;
            }
            catch (IOException e) {
            }
        }
        return null;
    }

    protected byte[] readFile(String name) {
        Enumeration classpath = this._urlClassPath.elements();
        byte[] data = null;
        while (data == null && classpath.hasMoreElements()) {
            URL base_path = (URL)classpath.nextElement();
            try {
                int octet;
                URL path = new URL(base_path, name);
                ByteArrayOutputStream out_buffer = new ByteArrayOutputStream();
                BufferedInputStream in = new BufferedInputStream(path.openStream());
                while ((octet = ((InputStream)in).read()) != -1) {
                    out_buffer.write(octet);
                }
                data = out_buffer.toByteArray();
            }
            catch (IOException e) {}
        }
        return data;
    }

    public static URL[] decodePathString(String classpath) {
        URL base_url = null;
        try {
            base_url = new URL("file:/");
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        Vector<URL> classpath_urls = new Vector<URL>();
        if (base_url != null && classpath != null) {
            StringTokenizer tok = new StringTokenizer(classpath, ",");
            while (tok.hasMoreTokens()) {
                String path = tok.nextToken();
                URL path_url = null;
                try {
                    path_url = new URL(path);
                }
                catch (MalformedURLException e) {
                    try {
                        path_url = new URL(base_url, path);
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                if (path_url == null) continue;
                classpath_urls.addElement(path_url);
            }
        }
        URL[] paths = null;
        if (!classpath_urls.isEmpty()) {
            paths = new URL[classpath_urls.size()];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = (URL)classpath_urls.elementAt(i);
            }
        }
        return paths;
    }

    public void forcePublic(byte[] theClass) {
        int constant_pool_count = (theClass[8] & 0xFF) << 8 | theClass[9] & 0xFF;
        int currOffset = 10;
        block6: for (int i = 1; i < constant_pool_count; ++i) {
            switch (theClass[currOffset] & 0xFF) {
                case 7: 
                case 8: {
                    currOffset += 3;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    currOffset += 5;
                    continue block6;
                }
                case 5: 
                case 6: {
                    currOffset += 9;
                    ++i;
                    continue block6;
                }
                case 1: {
                    int length = (theClass[++currOffset] & 0xFF) << 8 | theClass[++currOffset] & 0xFF;
                    currOffset += length + 1;
                    continue block6;
                }
                default: {
                    return;
                }
            }
        }
        int n = currOffset + 1;
        theClass[n] = (byte)(theClass[n] | 1);
    }

    public Vector get_urlClassPath() {
        return this._urlClassPath;
    }

    public void set_urlClassPath(Vector val) {
        this._urlClassPath = val;
    }

    public Hashtable get_classCache() {
        return this._classCache;
    }

    public void set_classCache(Hashtable val) {
        this._classCache = val;
    }
}

