/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class StandardLoader
extends ClassLoader {
    protected Object[] _classPath;

    public StandardLoader(String classPath) {
        StringTokenizer st = new StringTokenizer(classPath, System.getProperty("path.separator"));
        this._classPath = new Object[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            this._classPath[index++] = this.initPath(st.nextToken());
        }
    }

    protected Object initPath(String name) {
        if (name.substring(name.length() - ".zip".length()).equalsIgnoreCase(".zip")) {
            return this.initZipFile(name);
        }
        return this.initDirectory(name);
    }

    protected File initDirectory(String name) {
        try {
            File dir = new File(name);
            if (!dir.isDirectory()) {
                throw new IOException();
            }
            return dir;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public ZipFile initZipFile(String name) {
        try {
            ZipFile zip = new ZipFile(name);
            return zip;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.findSystemClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = this.findLoadedClass(name);
        }
        if (clazz == null) {
            byte[] class_data = null;
            for (int i = 0; i < this._classPath.length; ++i) {
                if (this._classPath[i] == null) continue;
                try {
                    class_data = this.loadClassDef(this._classPath[i], name);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (class_data != null) break;
            }
            if (class_data != null) {
                clazz = this.defineClass(name, class_data, 0, class_data.length);
                if (resolve) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        throw new ClassNotFoundException("Cannot load class: " + name);
    }

    public byte[] loadClassDef(Object from, String name) throws IOException {
        byte[] data = null;
        name = name.replace('.', File.separatorChar) + ".class";
        if (from instanceof File && ((File)from).isDirectory()) {
            File from_file = (File)from;
            File class_file = new File(from_file, name);
            data = new byte[(int)class_file.length()];
            new FileInputStream(class_file).read(data);
            return data;
        }
        if (from instanceof ZipFile) {
            ZipFile zip = (ZipFile)from;
            ZipEntry class_entry = zip.getEntry(name);
            if (class_entry == null) {
                throw new IOException("Entry doesn't exist");
            }
            data = new byte[(int)class_entry.getSize()];
            zip.getInputStream(class_entry).read(data);
            return data;
        }
        return null;
    }

    public Object[] get_classPath() {
        return this._classPath;
    }

    public void set_classPath(Object[] val) {
        this._classPath = val;
    }
}

