/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.util;

import java.util.Vector;
import javax.swing.SwingUtilities;
import org.javagroup.util.Disposable;
import org.javagroup.util.ResourceDisposalListener;

public class Resource
implements Disposable {
    private static Vector __resources;
    protected int _references;
    protected boolean _static;
    protected Vector _disposalListeners = new Vector();
    protected Disposable _wrappedResource;
    protected boolean _disposed = false;

    public Resource() {
    }

    public Resource(Disposable disposable) {
        this();
        this._wrappedResource = disposable;
    }

    public synchronized void addLock() {
        ++this._references;
    }

    public synchronized void releaseLock() {
        if (!this._static) {
            --this._references;
            if (this._references <= 0) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        Resource.this.dispose();
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public synchronized void setStatic() {
        if (!this._static) {
            __resources.addElement(this);
        }
        this._static = true;
    }

    public void unregister() {
        if (__resources.contains(this)) {
            __resources.removeElement(this);
        }
    }

    public void dispose() {
        if (this._disposed) {
            return;
        }
        if (this._wrappedResource != null) {
            this._wrappedResource.dispose();
        }
        this.fireResourceDisposalEvent();
        this._disposalListeners.removeAllElements();
        this._disposed = true;
    }

    public boolean isDisposed() {
        return this._disposed;
    }

    public void addDisposalListener(ResourceDisposalListener resourcedisposallistener) {
        this._disposalListeners.addElement(resourcedisposallistener);
    }

    public void removeDisposalListener(ResourceDisposalListener resourcedisposallistener) {
        this._disposalListeners.removeElement(resourcedisposallistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireResourceDisposalEvent() {
        Vector vector = this._disposalListeners;
        synchronized (vector) {
            for (int i = 0; i < this._disposalListeners.size(); ++i) {
                ResourceDisposalListener resourcedisposallistener = (ResourceDisposalListener)this._disposalListeners.elementAt(i);
                resourcedisposallistener.resourceDisposed(this);
            }
        }
    }
}

