/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.tools.processmanager;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessEventListener;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessManagerHolder;
import org.javagroup.tools.processmanager.ProcessTableEntry;

public class ProcessDataModel
extends AbstractTableModel
implements ProcessEventListener {
    protected Vector _processTableEntries = new Vector();
    private static String __NAME = "Process name (including argument list)";
    public static final int C_PID = 0;
    public static final int C_NAME = 1;
    public int numColumns = 2;

    public ProcessDataModel() {
        ProcessManager processmanager = ProcessManagerHolder.getProcessManager();
        Enumeration enumeration = processmanager.getProcesses();
        while (enumeration.hasMoreElements()) {
            this.createProcessTableEntry((JProcess)enumeration.nextElement());
        }
        processmanager.addProcessEventListener(this);
    }

    protected void createProcessTableEntry(JProcess jprocess) {
        ProcessTableEntry processtableentry = new ProcessTableEntry(jprocess);
        this._processTableEntries.addElement(processtableentry);
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public int getRowCount() {
        return this._processTableEntries.size();
    }

    public Object getValueAt(int i, int j) {
        if (i >= this.getRowCount()) {
            return "";
        }
        ProcessTableEntry processtableentry = (ProcessTableEntry)this._processTableEntries.elementAt(i);
        if (j == 0) {
            return String.valueOf(processtableentry._pid);
        }
        if (j == 1) {
            return processtableentry._name;
        }
        return "NO DATA";
    }

    public boolean isCellEditable(int i, int j) {
        return j == 0;
    }

    public void setValueAt(Object obj, int i, int j) {
        if (i > this.getRowCount()) {
            return;
        }
        ProcessTableEntry processtableentry = (ProcessTableEntry)this._processTableEntries.elementAt(i);
        ProcessManagerHolder.getProcessManager().kill(processtableentry._pid);
        this.fireTableDataChanged();
    }

    public String getColumnName(int i) {
        switch (i) {
            case 0: {
                return "PID";
            }
            case 1: {
                return __NAME;
            }
        }
        return "Undefined";
    }

    public Class getColumnClass(int i) {
        return this.getValueAt(0, i).getClass();
    }

    public void processCreated(JProcess jprocess) {
        this.createProcessTableEntry(jprocess);
        this.fireTableDataChanged();
    }

    public void processDestroyed(JProcess jprocess) {
        this._processTableEntries.removeElement(new ProcessTableEntry(jprocess));
        this.fireTableDataChanged();
    }
}

