/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.tools.processmanager;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.process.ProcessManagerHolder;
import org.javagroup.swing.HistoryComboModel;

public class LaunchProcessPanel
extends JPanel
implements ActionListener {
    protected HistoryComboModel _comboModel;
    protected JComboBox _classNameField;
    protected JButton _launchButton;

    public LaunchProcessPanel() {
        this.instantiateComponents();
        this.addAndLayoutComponents();
        this.registerListeners();
    }

    protected void instantiateComponents() {
        this._comboModel = new HistoryComboModel();
        this._classNameField = new JComboBox();
        this._classNameField.setEditable(true);
        this._launchButton = new JButton("Launch");
    }

    protected void addAndLayoutComponents() {
        GridBagLayout gridbaglayout = new GridBagLayout();
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        this.setLayout(gridbaglayout);
        gridbagconstraints.anchor = 11;
        gridbagconstraints.fill = 2;
        gridbagconstraints.weightx = 1.0;
        gridbagconstraints.weighty = 0.0;
        gridbaglayout.setConstraints(this._classNameField, gridbagconstraints);
        this.add(this._classNameField);
        gridbagconstraints.fill = 0;
        gridbagconstraints.gridheight = 0;
        gridbagconstraints.weightx = 0.0;
        gridbaglayout.setConstraints(this._launchButton, gridbagconstraints);
        this.add(this._launchButton);
    }

    protected void registerListeners() {
        this._launchButton.addActionListener(this);
    }

    protected void showErrorDialog(Exception exception) {
        System.out.println(exception);
    }

    public void actionPerformed(ActionEvent actionevent) {
        String s = (String)this._classNameField.getSelectedItem();
        try {
            this._comboModel.addToHistory(s);
            ProcessManagerHolder.getProcessManager().createProcessFromString(s).launch();
        }
        catch (ProcessCreationException processcreationexception) {
            this.showErrorDialog(processcreationexception);
        }
    }
}

