/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.process;

import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.process.ProcessEventListener;
import org.javagroup.process.ProcessGarbageCollector;
import org.javagroup.process.ProcessLifeToken;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessNamespace;
import org.javagroup.process.ProcessSecurityManager;
import org.javagroup.process.StandardJProcess;
import org.javagroup.util.Namespace;
import org.javagroup.util.Resource;
import org.javagroup.util.ResourceDisposalListener;
import org.javagroup.util.StandardIO;
import org.javagroup.util.URLClassLoader;

public class StandardProcessManager
implements ProcessManager,
ResourceDisposalListener {
    protected URL[] _classpath;
    protected Hashtable _processes;
    protected ProcessSecurityManager _securityManager;
    protected Vector _processEventListeners;
    protected ProcessGarbageCollector _garbageCollector;
    protected ProcessNamespace _namespace;
    protected Vector _garbageQueue;
    protected ThreadGroup _rootProcessGroup = new ThreadGroup("ThreadGroup for JProcesses");
    private long _nextpid;

    public StandardProcessManager() {
        this._processes = new Hashtable();
        this._processEventListeners = new Vector();
        this._garbageQueue = new Vector();
        this._garbageCollector = new ProcessGarbageCollector(this);
        this._namespace = new ProcessNamespace(this);
        Namespace.getNamespace().registerNamespace(this._namespace);
        this._securityManager = new ProcessSecurityManager(this);
        System.setSecurityManager(this._securityManager);
    }

    public StandardProcessManager(URL[] aurl) {
        this();
        this._classpath = aurl;
    }

    protected synchronized long getNextPid() {
        return this._nextpid++;
    }

    public JProcess createProcess(String s) throws ProcessCreationException {
        return this.createProcess(s, new String[0], null);
    }

    public JProcess createProcess(String s, String[] as) throws ProcessCreationException {
        return this.createProcess(s, as, null);
    }

    public synchronized JProcess createProcess(String s, String[] as, URL[] aurl) throws ProcessCreationException {
        StandardIO.ensureSystemWrappersInstalled();
        aurl = aurl == null ? this._classpath : this.mergeWithDefaultClasspath(aurl);
        StandardJProcess standardjprocess = new StandardJProcess(s, this.getNextPid(), as, this._rootProcessGroup, aurl);
        ProcessLifeToken processlifetoken = new ProcessLifeToken(standardjprocess);
        processlifetoken.addDisposalListener(this);
        standardjprocess.registerResource(processlifetoken);
        this._processes.put(new Long(standardjprocess.getPid()), standardjprocess);
        this.fireProcessCreationEvent(standardjprocess);
        this._namespace.registerNamespaceForProcess(new Namespace(), standardjprocess);
        return standardjprocess;
    }

    public JProcess createProcessFromString(String s) throws ProcessCreationException {
        return this.createProcessFromString(s, null);
    }

    public JProcess createProcessFromString(String s, URL[] aurl) throws ProcessCreationException {
        StringTokenizer stringtokenizer = new StringTokenizer(s, " ");
        if (stringtokenizer.countTokens() < 1) {
            throw new ProcessCreationException("Invalid parameter string.");
        }
        String s1 = stringtokenizer.nextToken();
        if (s1.equals("-eclasspath")) {
            if (!stringtokenizer.hasMoreTokens()) {
                throw new ProcessCreationException("Must specify a classpath with -eclasspath option");
            }
            URL[] aurl1 = URLClassLoader.decodePathString(stringtokenizer.nextToken());
            if (aurl == null || aurl.length == 0) {
                aurl = aurl1;
            } else if (aurl1 != null || aurl1.length != 0) {
                int i = aurl.length + aurl1.length;
                URL[] aurl2 = new URL[i];
                System.arraycopy(aurl1, 0, aurl2, 0, aurl1.length);
                System.arraycopy(aurl, 0, aurl2, aurl1.length, aurl2.length);
                aurl = aurl2;
            }
            if (!stringtokenizer.hasMoreTokens()) {
                throw new ProcessCreationException("Must specify a classname");
            }
            s1 = stringtokenizer.nextToken();
        }
        String[] as = new String[stringtokenizer.countTokens()];
        for (int j = 0; j < as.length; ++j) {
            as[j] = stringtokenizer.nextToken();
        }
        return this.createProcess(s1, as, aurl);
    }

    public JProcess getProcessFor(ThreadGroup threadgroup) {
        Enumeration enumeration = this._processes.elements();
        JProcess jprocess = null;
        while (jprocess == null && enumeration.hasMoreElements()) {
            JProcess jprocess1 = (JProcess)enumeration.nextElement();
            ThreadGroup threadgroup1 = jprocess1.getThreadGroup();
            if (!threadgroup1.parentOf(threadgroup)) continue;
            jprocess = jprocess1;
        }
        return jprocess;
    }

    public JProcess getProcessFor(ClassLoader classloader) {
        Enumeration enumeration = this._processes.elements();
        JProcess jprocess = null;
        while (jprocess == null && enumeration.hasMoreElements()) {
            JProcess jprocess1 = (JProcess)enumeration.nextElement();
            ClassLoader classloader1 = jprocess1.getClassLoader();
            if (classloader != classloader1) continue;
            jprocess = jprocess1;
        }
        return jprocess;
    }

    protected URL[] mergeWithDefaultClasspath(URL[] aurl) {
        if (this._classpath == null) {
            return aurl;
        }
        if (aurl == null) {
            return this._classpath;
        }
        URL[] aurl1 = new URL[aurl.length + this._classpath.length];
        for (int i = 0; i < aurl.length; ++i) {
            aurl1[i] = aurl[i];
        }
        for (int j = 0; j < this._classpath.length; ++j) {
            aurl1[j + aurl.length] = this._classpath[j];
        }
        return aurl1;
    }

    public JProcess getCurrentProcess() {
        return this._securityManager.getCurrentProcess();
    }

    public JProcess getProcess(long l) {
        return (JProcess)this._processes.get(new Long(l));
    }

    public Enumeration getProcesses() {
        return this._processes.elements();
    }

    public synchronized void kill(long l) {
        JProcess jprocess = (JProcess)this._processes.remove(new Long(l));
        if (jprocess != null) {
            this._garbageQueue.addElement(jprocess);
            this._garbageCollector.wakeUp();
        }
    }

    public void addProcessEventListener(ProcessEventListener processeventlistener) {
        this._processEventListeners.addElement(processeventlistener);
    }

    public void removeProcessEventListener(ProcessEventListener processeventlistener) {
        this._processEventListeners.removeElement(processeventlistener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProcessDestructionEvent(JProcess jprocess) {
        Vector vector = this._processEventListeners;
        synchronized (vector) {
            for (int i = 0; i < this._processEventListeners.size(); ++i) {
                ProcessEventListener processeventlistener = (ProcessEventListener)this._processEventListeners.elementAt(i);
                processeventlistener.processDestroyed(jprocess);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireProcessCreationEvent(JProcess jprocess) {
        Vector vector = this._processEventListeners;
        synchronized (vector) {
            for (int i = 0; i < this._processEventListeners.size(); ++i) {
                ProcessEventListener processeventlistener = (ProcessEventListener)this._processEventListeners.elementAt(i);
                processeventlistener.processCreated(jprocess);
            }
        }
    }

    public void resourceDisposed(Resource resource) {
        if (resource instanceof ProcessLifeToken) {
            JProcess jprocess = ((ProcessLifeToken)resource).getProcess();
            this.kill(jprocess.getPid());
        }
    }

    public synchronized void doGarbageCollect() {
        StandardIO.ensureSystemWrappersInstalled();
        Enumeration enumeration = this._garbageQueue.elements();
        while (enumeration.hasMoreElements()) {
            StandardJProcess standardjprocess = (StandardJProcess)enumeration.nextElement();
            standardjprocess.kill();
            this._namespace.removeNamespaceForProcess(standardjprocess);
            this.fireProcessDestructionEvent(standardjprocess);
        }
        this._garbageQueue.removeAllElements();
        Enumeration enumeration1 = this._processes.elements();
        while (enumeration1.hasMoreElements()) {
            StandardJProcess standardjprocess1 = (StandardJProcess)enumeration1.nextElement();
            standardjprocess1.tryGarbageCollect();
        }
        System.gc();
    }

    public Namespace getNamespaceForProcess(JProcess jprocess) {
        return this._namespace.getNamespaceForProcess(jprocess);
    }

    public void setStandardIOForProcess(JProcess jprocess, StandardIO standardio) {
        Namespace namespace = this.getNamespaceForProcess(jprocess);
        namespace.registerInstanceForClass(StandardIO.class, standardio);
    }

    public StandardIO getStandardIOForProcess(JProcess jprocess) {
        Namespace namespace = this.getNamespaceForProcess(jprocess);
        return (StandardIO)namespace.getInstanceForClass(StandardIO.class);
    }
}

