/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.process;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.Vector;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.util.Resource;
import org.javagroup.util.ResourceDisposalListener;

public class StandardJProcess
implements Runnable,
JProcess,
ResourceDisposalListener {
    protected long _pid;
    protected String _name;
    protected Date _creationdate;
    protected URLClassLoader _classLoader;
    protected ThreadGroup _processThreadGroup;
    protected Vector _lockedResources;
    protected Vector _resourcesLockedTo;
    protected int _state;
    protected int _exitCode;
    private Method _targetMethod;
    private String[] _args;
    private Thread _mainThread;
    private boolean _isKilled;

    public StandardJProcess(String s, long l, String[] as, ThreadGroup threadgroup, URL[] aurl) throws ProcessCreationException {
        this._name = s;
        this._creationdate = new Date();
        this._args = as;
        this.setState(0);
        this._lockedResources = new Vector();
        this._resourcesLockedTo = new Vector();
        if (this._args == null) {
            this._args = new String[0];
        }
        for (int i = 0; i < this._args.length; ++i) {
            this._name = this._name + " " + this._args[i];
        }
        this._pid = l;
        this._classLoader = null;
        this._classLoader = aurl != null ? URLClassLoader.newInstance(aurl) : URLClassLoader.newInstance(null);
        this._processThreadGroup = this.createThreadGroup(threadgroup);
        try {
            this.setTargetClass(s);
        }
        catch (ClassNotFoundException classnotfoundexception) {
            throw new ProcessCreationException(classnotfoundexception.toString());
        }
        catch (Exception exception) {
            throw new ProcessCreationException(exception.toString());
        }
    }

    public void launch() {
        this._mainThread = new Thread(this._processThreadGroup, this, "Main thread for " + this._name);
        this._mainThread.start();
        this.setState(1);
        Thread.yield();
    }

    public Thread getMainThread() {
        return this._mainThread;
    }

    public void addClassPath(URL[] aurl) {
    }

    public void run() {
        try {
            Object[] aobj = new Object[]{this._args};
            this._targetMethod.invoke(null, aobj);
        }
        catch (InvocationTargetException invocationtargetexception) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected URLClassLoader createClassLoader() {
        URL[] aurl = null;
        return URLClassLoader.newInstance(aurl);
    }

    protected ThreadGroup createThreadGroup(ThreadGroup threadgroup) {
        ThreadGroup threadgroup1 = new ThreadGroup(threadgroup, this.toString());
        threadgroup1.setMaxPriority(9);
        return threadgroup1;
    }

    private void setTargetClass(String s) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> class1 = this._classLoader.loadClass(s);
        Class[] aclass = new Class[]{String[].class};
        this._targetMethod = class1.getMethod("main", aclass);
        if ((this._targetMethod.getModifiers() & 8) == 0 || (this._targetMethod.getModifiers() & 1) == 0) {
            throw new NoSuchMethodException("main(String[]) method of " + class1.getName() + " is not public and static.");
        }
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public ThreadGroup getThreadGroup() {
        return this._processThreadGroup;
    }

    public synchronized void registerResource(Resource resource) {
        if (!this._lockedResources.contains(resource)) {
            this._lockedResources.addElement(resource);
            resource.addLock();
        }
    }

    public synchronized void registerAndBindToResource(Resource resource) {
        this.registerResource(resource);
        this.bindToResource(resource);
    }

    public synchronized void bindToResource(Resource resource) {
        if (!this._resourcesLockedTo.contains(resource)) {
            this._resourcesLockedTo.addElement(resource);
            resource.addDisposalListener(this);
        }
    }

    public synchronized void releaseResources() {
        Object[] aresource = new Resource[this._lockedResources.size()];
        this._lockedResources.copyInto(aresource);
        for (int i = 0; i < aresource.length; ++i) {
            this.releaseResource((Resource)aresource[i]);
        }
    }

    protected synchronized void releaseResource(Resource resource) {
        if (this._lockedResources.contains(resource)) {
            try {
                resource.releaseLock();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this._lockedResources.removeElement(resource);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this._resourcesLockedTo.contains(resource)) {
            this._resourcesLockedTo.removeElement(resource);
        }
    }

    public void resourceDisposed(Resource resource) {
        this.releaseResource(resource);
    }

    public synchronized void kill() {
        if (this._isKilled) {
            return;
        }
        this.setState(2);
        this.releaseResources();
        this._isKilled = true;
        this._processThreadGroup.stop();
        this._classLoader = null;
    }

    private synchronized void kill_destroyThreadGroup() {
        if (this._processThreadGroup != null) {
            this._processThreadGroup.destroy();
            this._processThreadGroup = null;
        }
    }

    public synchronized void tryGarbageCollect() {
        if (this._state != 0 && this._state != 2 && this._resourcesLockedTo.isEmpty() && this._processThreadGroup.activeCount() <= 0) {
            this.kill();
            this.kill_destroyThreadGroup();
        }
    }

    public long getPid() {
        return this._pid;
    }

    public String getName() {
        return this._name;
    }

    public Date getCreationDate() {
        return this._creationdate;
    }

    public int getState() {
        return this._state;
    }

    protected synchronized void setState(int i) {
        this._state = i;
        this.notifyAll();
    }

    public synchronized void waitFor() {
        while (this.getState() != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public int getExitCode() {
        return this._exitCode;
    }

    public void setExitCode(int i) {
        this._exitCode = i;
    }

    public String toString() {
        return String.valueOf(this._pid) + ": " + this._name;
    }
}

