/*
 * Decompiled with CFR 0.152.
 */
package org.javagroup.process;

import java.util.Hashtable;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessManager;
import org.javagroup.util.Namespace;

public class ProcessNamespace
extends Namespace {
    protected ProcessManager _processManager;
    protected Hashtable _processToNamespaceMap;

    public ProcessNamespace(ProcessManager processmanager) {
        this._processManager = processmanager;
        this._processToNamespaceMap = new Hashtable();
    }

    public synchronized void registerNamespaceToProcess(Namespace namespace, JProcess jprocess) {
        if (jprocess != null) {
            Namespace namespace1 = this.getNamespaceForProcess(jprocess);
            if (namespace1 != null) {
                namespace1.registerNamespace(namespace);
            }
        } else {
            super.registerNamespace(namespace);
        }
    }

    public synchronized void registerNamespace(Namespace namespace) {
        this.registerNamespaceToProcess(namespace, this._processManager.getCurrentProcess());
    }

    public synchronized void registerNamespaceForProcess(Namespace namespace, JProcess jprocess) {
        this._processToNamespaceMap.put(jprocess, namespace);
    }

    public synchronized Namespace getNamespaceForProcess(JProcess jprocess) {
        if (jprocess == null) {
            return null;
        }
        Namespace namespace = (Namespace)this._processToNamespaceMap.get(jprocess);
        if (namespace == null) {
            namespace = new Namespace();
            this._processToNamespaceMap.put(jprocess, namespace);
        }
        return namespace;
    }

    public synchronized void removeNamespaceForProcess(JProcess jprocess) {
        this._processToNamespaceMap.remove(jprocess);
    }

    public synchronized void registerInstanceForClass(Class class1, Object obj) {
        Namespace namespace = this.getNamespaceForProcess(this._processManager.getCurrentProcess());
        if (namespace != null) {
            namespace.registerInstanceForClass(class1, obj);
        } else {
            super.registerInstanceForClass(class1, obj);
        }
    }

    public synchronized Object getInstanceForClass(Class class1) {
        Namespace namespace = this.getNamespaceForProcess(this._processManager.getCurrentProcess());
        Object obj = null;
        if (namespace != null) {
            obj = namespace.getInstanceForClass(class1);
        }
        if (obj == null) {
            obj = super.getInstanceForClass(class1);
        }
        return obj;
    }
}

