/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.jdsvm.manager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import org.beanizer.jdsvm.Jdsvm;
import org.beanizer.jdsvm.JdsvmListener;

public class JdsvmManagerSwing
extends JFrame
implements JdsvmListener,
ActionListener {
    private Jdsvm jdsvm = null;
    private URL[] url;
    String[] statusIcon = new String[3];
    private JTable activeProcessTable;
    private JTextField classpathTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuItem jMenuItem1;
    private JMenuBar jMenuBar1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JButton killButton;
    private JButton launchButton;
    private JTextField programTextField;
    private JButton refreshButton;
    private ProcessTableModel processTableModel = null;

    private void pmInitialize() {
        try {
            this.jdsvm = Jdsvm.getInstance();
            this.jdsvm.addJdsvmListener(this);
            this.initComponents();
            this.statusIcon[0] = "unstarted";
            this.statusIcon[1] = "running";
            this.statusIcon[2] = "dead";
            this.listProcess();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.setTitle("JDSVM Manager");
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.programTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.classpathTextField = new JTextField();
        this.launchButton = new JButton();
        this.jPanel3 = new JPanel();
        this.activeProcessTable = new JTable();
        this.jPanel4 = new JPanel();
        this.killButton = new JButton();
        this.refreshButton = new JButton();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowevent) {
                JdsvmManagerSwing.this.exitForm(windowevent);
            }
        });
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Program");
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 5.0;
        this.jPanel1.add((Component)this.jLabel1, gridbagconstraints);
        this.programTextField.setName("programTextField");
        this.programTextField.setPreferredSize(new Dimension(400, 27));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(5, 0, 5, 0);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 100.0;
        this.jPanel1.add((Component)this.programTextField, gridbagconstraints);
        this.jLabel2.setText("Classpath");
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridy = 100;
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 5.0;
        this.jPanel1.add((Component)this.jLabel2, gridbagconstraints);
        this.classpathTextField.setName("classpathTextField");
        this.classpathTextField.setPreferredSize(new Dimension(400, 27));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridy = 100;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(0, 0, 5, 0);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 100.0;
        this.jPanel1.add((Component)this.classpathTextField, gridbagconstraints);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(0, 0, 10, 0);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 100.0;
        this.jPanel2.add((Component)this.jPanel1, gridbagconstraints);
        this.launchButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/jdsvm/img/launch.gif")));
        this.launchButton.setText("Launch");
        this.launchButton.setName("launchButton");
        this.launchButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseevent) {
                JdsvmManagerSwing.this.launchButtonMouseClicked(mouseevent);
            }
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.fill = 3;
        gridbagconstraints.insets = new Insets(5, 5, 15, 5);
        this.jPanel2.add((Component)this.launchButton, gridbagconstraints);
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel3.setBorder(new TitledBorder(null, "Active processes", 0, 0, new Font("Dialog", 1, 11)));
        JScrollPane jscrollpane = new JScrollPane(this.activeProcessTable);
        this.activeProcessTable.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.processTableModel = new ProcessTableModel(new Object[][]{{"", "", ""}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"ID", "Process name", "Status"});
        this.activeProcessTable.setModel(this.processTableModel);
        this.activeProcessTable.getColumnModel().getColumn(0).setMaxWidth(30);
        this.activeProcessTable.getColumnModel().getColumn(2).setMaxWidth(100);
        this.jPanel3.add((Component)jscrollpane, "Center");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.killButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/jdsvm/img/kill.gif")));
        this.killButton.setText("Kill");
        this.killButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseevent) {
                JdsvmManagerSwing.this.killButtonMouseClicked(mouseevent);
            }
        });
        this.jPanel4.add(this.killButton);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/beanizer/jdsvm/img/refresh.gif")));
        this.refreshButton.setText("Refresh");
        this.refreshButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseevent) {
                JdsvmManagerSwing.this.refreshButtonMouseClicked(mouseevent);
            }
        });
        this.jPanel4.add(this.refreshButton);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jMenu1.setText("History");
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        Enumeration enumeration = this.jdsvm.getCommands().keys();
        while (enumeration.hasMoreElements()) {
            this.addMenuItem((String)enumeration.nextElement());
        }
        this.pack();
    }

    private void refreshButtonMouseClicked(MouseEvent mouseevent) {
        this.listProcess();
    }

    private void killButtonMouseClicked(MouseEvent mouseevent) {
        if (this.activeProcessTable.getSelectedRow() > -1) {
            Runnable runnable = new Runnable(){

                public void run() {
                    JdsvmManagerSwing.this.jdsvm.killProcess((String)JdsvmManagerSwing.this.processTableModel.getValueAt(JdsvmManagerSwing.this.activeProcessTable.getSelectedRow(), 0));
                }
            };
            new Thread(runnable).start();
        }
    }

    private void launchButtonMouseClicked(MouseEvent mouseevent) {
        Runnable runnable = new Runnable(){

            public void run() {
                JdsvmManagerSwing.this.launchProcess(JdsvmManagerSwing.this.programTextField.getText(), JdsvmManagerSwing.this.classpathTextField.getText());
            }
        };
        new Thread(runnable).start();
    }

    private void exitForm(WindowEvent windowevent) {
        System.exit(0);
    }

    public static void main(String[] strings) {
        JdsvmManagerSwing jdsvmmanagerswing = new JdsvmManagerSwing();
        jdsvmmanagerswing.pmInitialize();
        jdsvmmanagerswing.setVisible(true);
    }

    public void launchProcess(String string, String string_12_) {
        this.jdsvm.launchProcess(string, string_12_);
    }

    private void addMenuItem(String string) {
        final JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.addActionListener(this);
        final String pr = string;
        Runnable runnable = new Runnable(){

            public void run() {
                jMenuItem.setText(pr);
                JdsvmManagerSwing.this.jMenu1.add(jMenuItem);
                JdsvmManagerSwing.this.jMenu1.repaint();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void actionPerformed(ActionEvent actionevent) {
        final JMenuItem source = (JMenuItem)actionevent.getSource();
        final URL[] cp1 = (URL[])this.jdsvm.getCommands().get(source.getText());
        Runnable runnable = new Runnable(){

            public void run() {
                JdsvmManagerSwing.this.jdsvm.launchProcessFromXmlRPC(source.getText(), cp1);
            }
        };
        new Thread(runnable).start();
    }

    private void launchFromMenu(String string) {
    }

    protected void listProcess() {
        Vector vector = this.jdsvm.getProcessList();
        Object[][] objects = new Object[vector.size() + 1][3];
        Enumeration enumeration = vector.elements();
        for (int i = 0; i < vector.size(); ++i) {
            HashMap hashmap = (HashMap)enumeration.nextElement();
            objects[i][0] = hashmap.get("pid");
            objects[i][1] = hashmap.get("name");
            objects[i][2] = "running";
        }
        this.processTableModel.setDataVector(objects, new String[]{"ID", "Process name", "Status"});
        this.processTableModel.fireTableDataChanged();
    }

    public void processCreated(String string, String string_16_, int i) {
        this.listProcess();
        if (!this.jdsvm.getCommands().containsKey(string_16_)) {
            this.addMenuItem(string_16_);
        }
    }

    public void processDestroyed(String string, String string_17_) {
        this.listProcess();
    }

    public void jdsvmError(Throwable throwable) {
        throwable.printStackTrace();
    }

    class ProcessTableModel
    extends AbstractTableModel {
        private String[] columnNames;
        private Object[][] data;
        private boolean DEBUG = false;

        public ProcessTableModel(Object[][] objects, String[] strings) {
            this.columnNames = strings;
            this.data = objects;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public String getColumnName(int i) {
            return this.columnNames[i];
        }

        public Object getValueAt(int i, int i_0_) {
            return this.data[i][i_0_];
        }

        public Class getColumnClass(int i) {
            return this.getValueAt(0, i).getClass();
        }

        public boolean isCellEditable(int i, int i_1_) {
            return false;
        }

        public void setValueAt(Object object, int i, int i_2_) {
            if (this.DEBUG) {
                System.out.println("Setting value at " + i + "," + i_2_ + " to " + object + " (an instance of " + object.getClass() + ")");
            }
            this.data[i][i_2_] = object;
            this.fireTableCellUpdated(i, i_2_);
            if (this.DEBUG) {
                System.out.println("New value of data:");
                this.printDebugData();
            }
        }

        public void setDataVector(Object[][] objects, String[] strings) {
            this.columnNames = strings;
            this.data = objects;
        }

        private void printDebugData() {
            int i = this.getRowCount();
            int i_3_ = this.getColumnCount();
            for (int i_4_ = 0; i_4_ < i; ++i_4_) {
                System.out.print("    row " + i_4_ + ":");
                for (int i_5_ = 0; i_5_ < i_3_; ++i_5_) {
                    System.out.print("  " + this.data[i_4_][i_5_]);
                }
                System.out.println();
            }
            System.out.println("--------------------------");
        }
    }
}

