/*
 * Decompiled with CFR 0.152.
 */
package org.beanizer.jdsvm;

import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;
import org.beanizer.jdsvm.JdsvmListener;
import org.beanizer.jdsvm.util.CommandLineParser;
import org.beanizer.jdsvm.util.StringUtils;
import org.beanizer.jdsvm.xmlrpc.engine.XmlRpcServer;
import org.javagroup.process.JProcess;
import org.javagroup.process.ProcessCreationException;
import org.javagroup.process.ProcessEventListener;
import org.javagroup.process.ProcessManager;
import org.javagroup.process.ProcessManagerHolder;

public class Jdsvm
implements ProcessEventListener {
    static Logger logger = Logger.getLogger((String)"Jdsvm");
    private static List listeners = new Vector();
    private transient ProcessManager manager = ProcessManagerHolder.getProcessManager();
    private static Jdsvm jdsvmSingl = null;
    private transient Hashtable commands = new Hashtable();
    private static boolean startManager = false;
    private static Properties properties = new Properties();

    private Jdsvm() {
    }

    private void jdsvmInitialize() {
        try {
            ProcessManagerHolder.getProcessManager().addProcessEventListener(this);
            logger.info((Object)"Jdsvm initialized");
        }
        catch (Exception exception) {
            logger.error((Object)("Jdsvm initialization failed : " + exception.getMessage()));
            exception.printStackTrace();
        }
        try {
            File file = new File("./conf/properties.conf");
            file.createNewFile();
            properties.load(new FileInputStream("./conf/properties.conf"));
        }
        catch (Exception exception) {
            logger.error((Object)("Jdsvm properties initialization failed : " + exception.getMessage()));
        }
    }

    public static Jdsvm getInstance() {
        if (jdsvmSingl == null) {
            jdsvmSingl = new Jdsvm();
            jdsvmSingl.jdsvmInitialize();
        }
        return jdsvmSingl;
    }

    public static boolean exists() {
        return jdsvmSingl != null;
    }

    public static void main(String[] strings) {
        PropertyConfigurator.configure((String)"./conf/log4j.conf");
        if (!Jdsvm.exists()) {
            int port = 8080;
            logger.info((Object)"*********************");
            logger.info((Object)"* JavaDesktopEngine *");
            logger.info((Object)"*        by         *");
            logger.info((Object)"*   beanizer.org    *");
            logger.info((Object)"*********************");
            CommandLineParser commandlineparser = new CommandLineParser();
            Hashtable hashtable = commandlineparser.parse(strings);
            if (hashtable == null) {
                System.out.println(commandlineparser.getLastError());
                System.exit(0);
            }
            if (hashtable.containsKey("help")) {
                System.out.println("HELP!!");
                System.exit(0);
            }
            if (hashtable.containsKey("LnF")) {
                try {
                    UIManager.setLookAndFeel((String)hashtable.get("LnF"));
                }
                catch (ClassNotFoundException classnotfoundexception) {
                    System.out.println("ERROR: class " + (String)hashtable.get("LnF") + " not found.");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (hashtable.containsKey("GUIManager")) {
                startManager = true;
            }
            if (hashtable.containsKey("port")) {
                port = Integer.parseInt((String)hashtable.get("port"));
            }
            new XmlRpcServer(port);
            Jdsvm jdsvm = Jdsvm.getInstance();
            jdsvm.launchProcess("org.beanizer.jdsvm.FakeProcess", "./");
            if (startManager) {
                jdsvm.launchProcess("org.beanizer.jdsvm.manager.ManagerSwing", "./");
            }
        } else {
            logger.info((Object)"Jdsvm instance already exists");
        }
    }

    public String launchProcess(String string, String string_0_) {
        return this.launchProcessFromXmlRPC(string, StringUtils.URLizeClasspath(string_0_));
    }

    public void killProcess(String string) {
        try {
            this.manager.getProcess(new Long(string)).kill();
        }
        catch (IllegalArgumentException illegalargumentexception) {
            logger.info((Object)"No process to kill selected");
        }
    }

    public Vector getProcessList() {
        Vector vector = new Vector();
        Enumeration enumeration = this.manager.getProcesses();
        while (enumeration.hasMoreElements()) {
            JProcess jprocess = (JProcess)enumeration.nextElement();
            HashMap<String, String> hashmap = new HashMap<String, String>();
            hashmap.put("pid", String.valueOf(jprocess.getPid()));
            hashmap.put("name", jprocess.getName());
            hashmap.put("state", String.valueOf(jprocess.getState()));
            hashmap.put("date", jprocess.getCreationDate().toString());
            vector.add(hashmap);
        }
        return vector;
    }

    public String launchProcessFromXmlRPC(String string, URL[] urls) {
        Object object = null;
        String string_1_ = "";
        try {
            JProcess jprocess = this.manager.createProcessFromString(string, urls);
            jprocess.launch();
            if (!this.commands.containsKey(string)) {
                this.commands.put(string.trim(), urls);
            }
            string_1_ = "Process launched";
        }
        catch (ProcessCreationException processcreationexception) {
            logger.info((Object)("Error crating process: " + processcreationexception.getMessage()));
            this.notifyError(processcreationexception);
            string_1_ = "Error crating process: " + processcreationexception.getMessage();
        }
        catch (Exception exception) {
            this.notifyError(exception);
            string_1_ = "Generic error: " + exception.getMessage();
        }
        return string_1_;
    }

    protected void updateCommonClasspath() {
    }

    public Hashtable getCommands() {
        return this.commands;
    }

    public void processCreated(JProcess jprocess) {
        logger.info((Object)("Process created : " + jprocess.getName()));
        Enumeration enumeration = ((Vector)listeners).elements();
        while (enumeration.hasMoreElements()) {
            ((JdsvmListener)enumeration.nextElement()).processCreated(String.valueOf(jprocess.getPid()), jprocess.getName(), jprocess.getState());
        }
    }

    public void processDestroyed(JProcess jprocess) {
        logger.info((Object)("Process destroyed : " + jprocess.getName()));
        Enumeration enumeration = ((Vector)listeners).elements();
        while (enumeration.hasMoreElements()) {
            ((JdsvmListener)enumeration.nextElement()).processDestroyed(String.valueOf(jprocess.getPid()), jprocess.getName());
        }
    }

    private void notifyError(Throwable throwable) {
        Enumeration enumeration = ((Vector)listeners).elements();
        while (enumeration.hasMoreElements()) {
            ((JdsvmListener)enumeration.nextElement()).jdsvmError(throwable);
        }
    }

    public void callBack() {
    }

    public void addJdsvmListener(JdsvmListener jdsvmlistener) {
        listeners.add(jdsvmlistener);
    }

    public void removeJdsvmListener(JdsvmListener jdsvmlistener) {
        if (listeners.contains(jdsvmlistener)) {
            listeners.remove(jdsvmlistener);
        }
    }

    public String getProperty(String string) {
        return properties.getProperty(string);
    }
}

